/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ibeans.config;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.mule.config.AnnotationsConfigurationBuilder;
import org.mule.util.ClassUtils;
import org.mule.util.StringMessageUtils;
import org.mule.util.scan.ClasspathScanner;

public abstract class AbstractAnnotationConfigurationBuilder
extends AnnotationsConfigurationBuilder {
    public static final String IBEANS_PROPERTIES = "META-INF/ibeans-app.properties";
    public static final String[] DEFAULT_BASE_PACKAGE = new String[]{""};
    protected ClassLoader classLoader;
    protected String[] basepackages;

    public AbstractAnnotationConfigurationBuilder() {
        this(DEFAULT_BASE_PACKAGE);
    }

    public AbstractAnnotationConfigurationBuilder(String ... basepackages) {
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.basepackages = basepackages;
    }

    public AbstractAnnotationConfigurationBuilder(ClassLoader classLoader) {
        this(classLoader, DEFAULT_BASE_PACKAGE);
    }

    public AbstractAnnotationConfigurationBuilder(ClassLoader classLoader, String ... basepackages) {
        this.classLoader = classLoader;
        this.basepackages = basepackages;
    }

    protected ClasspathScanner createClasspathScanner() throws IOException {
        if (Arrays.equals(DEFAULT_BASE_PACKAGE, this.basepackages)) {
            this.basepackages = this.findPackages();
        }
        String[] paths = this.convertPackagesToPaths(this.basepackages);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Scanning for annotations using the following paths: " + StringMessageUtils.toString((Object)paths)));
        }
        return new ClasspathScanner(this.classLoader, paths);
    }

    protected abstract String getScanPackagesProperty();

    protected String[] convertPackagesToPaths(String[] packages) {
        String[] paths = new String[packages.length];
        for (int i = 0; i < packages.length; ++i) {
            paths[i] = packages[i].replaceAll("[.]", "/");
        }
        return paths;
    }

    protected String[] findPackages() throws IOException {
        ArrayList<String> paths = new ArrayList<String>();
        Properties p = new Properties();
        Enumeration e = ClassUtils.getResources((String)IBEANS_PROPERTIES, ((Object)((Object)this)).getClass());
        boolean scanAll = false;
        block0: while (e.hasMoreElements()) {
            URL url = (URL)e.nextElement();
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("reading packages from: " + url));
            }
            p.load(url.openStream());
            String path = p.getProperty(this.getScanPackagesProperty());
            if (path == null) continue;
            StringTokenizer tokenizer = new StringTokenizer(path, ",");
            while (tokenizer.hasMoreTokens()) {
                String s = tokenizer.nextToken();
                if ("*".equals(s)) {
                    scanAll = true;
                    continue block0;
                }
                paths.add(s.trim());
            }
        }
        if (paths.size() == 0 || scanAll) {
            return DEFAULT_BASE_PACKAGE;
        }
        return paths.toArray(new String[0]);
    }
}

