/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.management.ManagedComponent;
import org.apache.cxf.management.annotation.ManagedAttribute;
import org.apache.cxf.management.annotation.ManagedOperation;
import org.apache.cxf.management.annotation.ManagedResource;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource(componentName="RMManager", description="Responsible for managing RMEndpoints.")
public class ManagedRMManager
implements ManagedComponent {
    private RMManager manager;

    public ManagedRMManager(RMManager manager) {
        this.manager = manager;
    }

    public ObjectName getObjectName() throws JMException {
        return RMUtils.getManagedObjectName(this.manager);
    }

    @ManagedOperation
    public void shutdown() {
        this.manager.shutdown();
    }

    @ManagedOperation
    public String[] getEndpointIdentifiers() {
        HashSet<String> identifiers = new HashSet<String>();
        for (Endpoint ep : this.getReliableEndpointsMap().keySet()) {
            identifiers.add(RMUtils.getEndpointIdentifier(ep));
        }
        return identifiers.toArray(new String[identifiers.size()]);
    }

    private Map<Endpoint, RMEndpoint> getReliableEndpointsMap() {
        HashMap<Endpoint, RMEndpoint> epmap = new HashMap<Endpoint, RMEndpoint>();
        for (ProtocolVariation pv : this.manager.getEndpointMaps().keySet()) {
            epmap.putAll(this.manager.getEndpointMaps().get((Object)pv));
        }
        return epmap;
    }

    @ManagedAttribute(description="Using Store")
    public boolean isUsingStore() {
        return this.manager.getStore() != null;
    }
}

