/*
 * $Id: ExceptionStrategyFlowRefTestCase.java 23555 2011-12-29 20:26:03Z pablo.lagreca $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.test.integration.exceptions;

import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;

import static org.junit.Assert.assertThat;

public class ExceptionStrategyFlowRefTestCase extends FunctionalTestCase
{

    public static final String MESSAGE = "some message";
    public static final int TIMEOUT = 5000;

    @Override
    protected String getConfigResources()
    {
        return "org/mule/test/integration/exceptions/exception-strategy-flow-ref.xml";
    }

    @Test
    public void testExceptionInFlowCalledWithFlowRef() throws Exception
    {
        LocalMuleClient client = muleContext.getClient();
        client.send("vm://inExceptionBlock", MESSAGE, null, TIMEOUT);
        MuleMessage response = client.request("jms://dlq", TIMEOUT);
        assertThat(response, IsNull.<Object>notNullValue());
        assertThat(response.<String>getInboundProperty("mainEs"), Is.is("yes"));
        assertThat(response.<String>getInboundProperty("flowRefEs"), Is.is("yes"));
    }
}
