/*
 * $Id: XAJdbcMule1479TestCase.java 23961 2012-03-07 16:48:42Z pablo.lagreca $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.test.integration.transaction;

import org.junit.runners.Parameterized;
import org.mule.module.client.MuleClient;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.junit.Test;
import org.mule.tck.AbstractServiceAndFlowTestCase;

import static org.junit.Assert.assertEquals;

public class XAJdbcMule1479TestCase extends AbstractDerbyTestCase
{
    
    public XAJdbcMule1479TestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources)
    {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters()
    {
        return Arrays.asList(new Object[][]{
            {AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/transaction/jdbc-xatransaction-1479.xml"},
            // The flow version does not work because flow doesn't support outgoing transaction configuration
            //{AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/transaction/jdbc-xatransaction-1479-flow.xml"}
        });
    }

    @Override
    protected void emptyTable() throws Exception
    {
        try
        {
            execSqlUpdate("DELETE FROM TEST");
        }
        catch (Exception e)
        {
            execSqlUpdate("CREATE TABLE TEST(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,DATA VARCHAR(255))");
        }
    }

    @Test
    public void testJdbcXa() throws Exception
    {
        MuleClient client = new MuleClient(muleContext);
        client.dispatch("vm://in","test",null);
        
        for (int i = 0; i < 10; i++)
        {
            List results = execSqlQuery("SELECT * FROM TEST");
            assertEquals(0, results.size());
            
            Thread.sleep(1000);
        }
    }

    @Test
    public void testJmsXa() throws Exception
    {
        MuleClient client = new MuleClient(muleContext);
        client.dispatch("vm://in1", "test", null);
        
        List results = null;
        for (int i = 0; i < 10; i++)
        {
            results = execSqlQuery("SELECT * FROM TEST");
            if (results.size() > 0)
            {
                break;
            }
            
            Thread.sleep(1000);
        }

        assertEquals(1, results.size());
    }

}
