/*
 * $Id: AbstractCompressionTransformer.java 19191 2010-08-25 21:05:23Z tcarlson $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.transformer.compression;

import org.mule.transformer.AbstractTransformer;
import org.mule.util.compression.CompressionStrategy;

/**
 * <code>AbstractCompressionTransformer</code> is a base class for all transformers
 * that can compress or uncompress data when they performa message transformation.
 * Compression is done via a pluggable strategy.
 */

public abstract class AbstractCompressionTransformer extends AbstractTransformer
{
    private CompressionStrategy strategy;

    /**
     * default constructor required for discovery
     */
    public AbstractCompressionTransformer()
    {
        super();
    }

    public CompressionStrategy getStrategy()
    {
        return strategy;
    }

    public void setStrategy(CompressionStrategy strategy)
    {
        this.strategy = strategy;
    }

}
