/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.tcp;

import java.io.IOException;
import java.net.Socket;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.transport.tcp.TcpConnector;
import org.mule.transport.tcp.TcpSocketFactory;
import org.mule.transport.tcp.TcpSocketKey;
import org.mule.util.MapUtils;

public abstract class AbstractTcpSocketFactory
implements KeyedPoolableObjectFactory {
    private static final Log logger = LogFactory.getLog(TcpSocketFactory.class);

    public Object makeObject(Object key) throws Exception {
        TcpSocketKey socketKey = (TcpSocketKey)key;
        Socket socket = this.createSocket(socketKey);
        socket.setReuseAddress(true);
        TcpConnector connector = socketKey.getConnector();
        connector.configureSocket(true, socket);
        return socket;
    }

    protected abstract Socket createSocket(TcpSocketKey var1) throws IOException;

    public void destroyObject(Object key, Object object) throws Exception {
        Socket socket = (Socket)object;
        if (!socket.isClosed()) {
            socket.close();
        }
    }

    public boolean validateObject(Object key, Object object) {
        Socket socket = (Socket)object;
        return !socket.isClosed();
    }

    public void activateObject(Object key, Object object) throws Exception {
    }

    public void passivateObject(Object key, Object object) throws Exception {
        TcpSocketKey socketKey = (TcpSocketKey)key;
        boolean keepSocketOpen = MapUtils.getBooleanValue((Map)socketKey.getEndpoint().getProperties(), (Object)"keepSendSocketOpen", (boolean)socketKey.getConnector().isKeepSendSocketOpen());
        Socket socket = (Socket)object;
        if (!keepSocketOpen) {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException e) {
                logger.debug((Object)("Failed to close socket after dispatch: " + e.getMessage()));
            }
        }
    }
}

