/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import org.apache.cxf.attachment.AttachmentDataSource;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.attachment.DelegatingInputStream;
import org.apache.cxf.attachment.LazyAttachmentCollection;
import org.apache.cxf.attachment.MimeBodyPartInputStream;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentDeserializer {
    public static final String ATTACHMENT_DIRECTORY = "attachment-directory";
    public static final String ATTACHMENT_MEMORY_THRESHOLD = "attachment-memory-threshold";
    public static final String ATTACHMENT_MAX_SIZE = "attachment-max-size";
    public static final int THRESHOLD = 102400;
    private static final Pattern CONTENT_TYPE_BOUNDARY_PATTERN = Pattern.compile("boundary=\"?([^\";]*)");
    private static final Pattern INPUT_STREAM_BOUNDARY_PATTERN = Pattern.compile("^--(\\S*)$", 8);
    private boolean lazyLoading = true;
    private int pbAmount = 2048;
    private PushbackInputStream stream;
    private int createCount;
    private int closedCount;
    private boolean closed;
    private byte[] boundary;
    private String contentType;
    private LazyAttachmentCollection attachments;
    private Message message;
    private InputStream body;
    private Set<DelegatingInputStream> loaded = new HashSet<DelegatingInputStream>();
    private List<String> supportedTypes;

    public AttachmentDeserializer(Message message) {
        this(message, Collections.singletonList("multipart/related"));
    }

    public AttachmentDeserializer(Message message, List<String> supportedTypes) {
        this.message = message;
        this.supportedTypes = supportedTypes;
    }

    public void initializeAttachments() throws IOException {
        this.initializeRootMessage();
        this.attachments = new LazyAttachmentCollection(this);
        this.message.setAttachments((Collection)this.attachments);
    }

    protected void initializeRootMessage() throws IOException {
        this.contentType = (String)this.message.get((Object)"Content-Type");
        if (this.contentType == null) {
            throw new IllegalStateException("Content-Type can not be empty!");
        }
        if (this.message.getContent(InputStream.class) == null) {
            throw new IllegalStateException("An InputStream must be provided!");
        }
        if (AttachmentUtil.isTypeSupported(this.contentType.toLowerCase(), this.supportedTypes)) {
            String boundaryString = this.findBoundaryFromContentType(this.contentType);
            if (null == boundaryString) {
                boundaryString = this.findBoundaryFromInputStream();
            }
            if (null == boundaryString) {
                throw new IOException("Couldn't determine the boundary from the message!");
            }
            this.boundary = boundaryString.getBytes("utf-8");
            this.stream = new PushbackInputStream((InputStream)this.message.getContent(InputStream.class), this.pbAmount);
            if (!AttachmentDeserializer.readTillFirstBoundary(this.stream, this.boundary)) {
                throw new IOException("Couldn't find MIME boundary: " + boundaryString);
            }
            try {
                String cs;
                InternetHeaders ih = new InternetHeaders((InputStream)this.stream);
                this.message.put((Object)InternetHeaders.class.getName(), (Object)ih);
                String val = ih.getHeader("Content-Type", "; ");
                if (!StringUtils.isEmpty((String)val) && !StringUtils.isEmpty((String)(cs = HttpHeaderHelper.findCharset((String)val)))) {
                    this.message.put((Object)Message.ENCODING, (Object)HttpHeaderHelper.mapCharset((String)cs));
                }
            }
            catch (MessagingException e) {
                throw new RuntimeException(e);
            }
            this.body = new DelegatingInputStream(new MimeBodyPartInputStream(this.stream, this.boundary, this.pbAmount), this);
            ++this.createCount;
            this.message.setContent(InputStream.class, (Object)this.body);
        }
    }

    private String findBoundaryFromContentType(String ct) throws IOException {
        Matcher m = CONTENT_TYPE_BOUNDARY_PATTERN.matcher(ct);
        return m.find() ? "--" + m.group(1) : null;
    }

    private String findBoundaryFromInputStream() throws IOException {
        InputStream is = (InputStream)this.message.getContent(InputStream.class);
        PushbackInputStream in = new PushbackInputStream(is, 4096);
        byte[] buf = new byte[2048];
        int i = in.read(buf);
        String msg = IOUtils.newStringFromBytes((byte[])buf, (int)0, (int)i);
        in.unread(buf, 0, i);
        this.message.setContent(InputStream.class, (Object)in);
        Matcher m = INPUT_STREAM_BOUNDARY_PATTERN.matcher(msg);
        return m.find() ? "--" + m.group(1) : null;
    }

    private void setStreamedAttachmentProperties(CachedOutputStream bos) throws IOException {
        Object threshold;
        Object directory = this.message.getContextualProperty(ATTACHMENT_DIRECTORY);
        if (directory != null) {
            if (directory instanceof File) {
                bos.setOutputDir((File)directory);
            } else {
                bos.setOutputDir(new File((String)directory));
            }
        }
        if ((threshold = this.message.getContextualProperty(ATTACHMENT_MEMORY_THRESHOLD)) != null) {
            if (threshold instanceof Long) {
                bos.setThreshold(((Long)threshold).longValue());
            } else {
                bos.setThreshold(Long.valueOf((String)threshold).longValue());
            }
        } else {
            bos.setThreshold(102400L);
        }
        Object maxSize = this.message.getContextualProperty(ATTACHMENT_MAX_SIZE);
        if (maxSize != null) {
            if (maxSize instanceof Long) {
                bos.setMaxSize(((Long)maxSize).longValue());
            } else {
                bos.setMaxSize(Long.valueOf((String)maxSize).longValue());
            }
        }
    }

    public AttachmentImpl readNext() throws IOException {
        InternetHeaders headers;
        this.cacheStreamedAttachments();
        if (this.closed) {
            return null;
        }
        int v = this.stream.read();
        if (v == -1) {
            return null;
        }
        this.stream.unread(v);
        try {
            headers = new InternetHeaders((InputStream)this.stream);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
        return (AttachmentImpl)this.createAttachment(headers);
    }

    private void cacheStreamedAttachments() throws IOException {
        if (this.body instanceof DelegatingInputStream && !((DelegatingInputStream)this.body).isClosed()) {
            this.cache((DelegatingInputStream)this.body, true);
        }
        ArrayList<Attachment> atts = new ArrayList<Attachment>(this.attachments.getLoadedAttachments());
        for (Attachment a : atts) {
            DataSource s = a.getDataHandler().getDataSource();
            if (s instanceof AttachmentDataSource) {
                AttachmentDataSource ads = (AttachmentDataSource)s;
                if (ads.isCached()) continue;
                ads.cache();
                continue;
            }
            if (!(s.getInputStream() instanceof DelegatingInputStream)) continue;
            this.cache((DelegatingInputStream)s.getInputStream(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cache(DelegatingInputStream input, boolean deleteOnClose) throws IOException {
        if (this.loaded.contains(input)) {
            return;
        }
        this.loaded.add(input);
        CachedOutputStream out = null;
        InputStream origIn = input.getInputStream();
        try {
            out = new CachedOutputStream();
            this.setStreamedAttachmentProperties(out);
            IOUtils.copy((InputStream)input, (OutputStream)out);
            input.setInputStream(out.getInputStream());
            origIn.close();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private static boolean readTillFirstBoundary(PushbackInputStream pbs, byte[] bp) throws IOException {
        int value = pbs.read();
        pbs.unread(value);
        while (value != -1) {
            int boundaryIndex;
            value = pbs.read();
            if ((byte)value != bp[0]) continue;
            for (boundaryIndex = 0; value != -1 && boundaryIndex < bp.length && (byte)value == bp[boundaryIndex]; ++boundaryIndex) {
                value = pbs.read();
                if (value != -1) continue;
                throw new IOException("Unexpected End while searching for first Mime Boundary");
            }
            if (boundaryIndex != bp.length) continue;
            if (value == 13) {
                pbs.read();
            }
            return true;
        }
        return false;
    }

    private Attachment createAttachment(InternetHeaders headers) throws IOException {
        DelegatingInputStream partStream = new DelegatingInputStream(new MimeBodyPartInputStream(this.stream, this.boundary, this.pbAmount), this);
        ++this.createCount;
        return AttachmentUtil.createAttachment(partStream, headers);
    }

    public boolean isLazyLoading() {
        return this.lazyLoading;
    }

    public void setLazyLoading(boolean lazyLoading) {
        this.lazyLoading = lazyLoading;
    }

    public void markClosed(DelegatingInputStream delegatingInputStream) throws IOException {
        ++this.closedCount;
        if (this.closedCount == this.createCount && !this.attachments.hasNext(false)) {
            int x = this.stream.read();
            while (x != -1) {
                x = this.stream.read();
            }
            this.stream.close();
            this.closed = true;
        }
    }

    public boolean hasNext() throws IOException {
        this.cacheStreamedAttachments();
        if (this.closed) {
            return false;
        }
        int v = this.stream.read();
        if (v == -1) {
            return false;
        }
        this.stream.unread(v);
        return true;
    }
}

