/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import org.apache.commons.httpclient.ChunkedOutputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpParser;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RequestContext;
import org.mule.api.transport.OutputHandler;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpRequest;
import org.mule.transport.http.HttpResponse;
import org.mule.transport.http.RequestLine;
import org.mule.transport.http.ResponseWriter;
import org.mule.util.SystemUtils;
import org.mule.util.concurrent.Latch;

public class HttpServerConnection
implements HandshakeCompletedListener {
    private static final Log logger = LogFactory.getLog(HttpServerConnection.class);
    private Socket socket;
    private final InputStream in;
    private final OutputStream out;
    private boolean keepAlive = false;
    private final String encoding;
    private HttpRequest cachedRequest;
    private Latch sslSocketHandshakeComplete = new Latch();
    private Certificate[] peerCertificateChain;
    private Certificate[] localCertificateChain;
    private RequestLine requestLine;

    public HttpServerConnection(Socket socket, String encoding, HttpConnector connector) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        this.socket = socket;
        if (this.socket instanceof SSLSocket) {
            ((SSLSocket)socket).addHandshakeCompletedListener(this);
        }
        this.setSocketTcpNoDelay();
        this.socket.setKeepAlive(connector.isKeepAlive());
        if (connector.getReceiveBufferSize() != -1 && socket.getReceiveBufferSize() != connector.getReceiveBufferSize()) {
            socket.setReceiveBufferSize(connector.getReceiveBufferSize());
        }
        if (connector.getServerSoTimeout() != -1 && socket.getSoTimeout() != connector.getServerSoTimeout()) {
            socket.setSoTimeout(connector.getServerSoTimeout());
        }
        this.in = socket.getInputStream();
        this.out = new DataOutputStream(socket.getOutputStream());
        this.encoding = encoding;
    }

    private void setSocketTcpNoDelay() throws IOException {
        try {
            this.socket.setTcpNoDelay(true);
        }
        catch (SocketException se) {
            if (SystemUtils.IS_OS_SOLARIS || SystemUtils.IS_OS_SUN_OS) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Failed to set tcpNoDelay on socket", (Throwable)se);
                }
            }
            throw se;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        block11: {
            try {
                if (this.socket == null) break block11;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Closing: " + this.socket));
                }
                try {
                    this.socket.shutdownOutput();
                }
                catch (UnsupportedOperationException e) {
                    // empty catch block
                }
                if (this.in != null) {
                    this.in.close();
                }
                if (this.out != null) {
                    this.out.close();
                }
                this.socket.close();
            }
            catch (IOException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("(Ignored) Error closing the socket: " + e.getMessage()));
                }
            }
            finally {
                this.socket = null;
            }
        }
    }

    public synchronized boolean isOpen() {
        return this.socket != null;
    }

    public void setKeepAlive(boolean b) {
        this.keepAlive = b;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public ResponseWriter getWriter() throws UnsupportedEncodingException {
        return new ResponseWriter(this.out);
    }

    public HttpRequest readRequest() throws IOException {
        if (this.cachedRequest != null) {
            return this.cachedRequest;
        }
        try {
            this.cachedRequest = new HttpRequest(this.getRequestLine(), HttpParser.parseHeaders((InputStream)this.in, (String)this.encoding), this.in, this.encoding);
            return this.cachedRequest;
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public HttpResponse readResponse() throws IOException {
        try {
            String line = this.readLine();
            return new HttpResponse(new StatusLine(line), HttpParser.parseHeaders((InputStream)this.in, (String)this.encoding), this.in);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    private String readLine() throws IOException {
        String line;
        while ((line = HttpParser.readLine((InputStream)this.in, (String)this.encoding)) != null && line.length() == 0) {
        }
        if (line == null) {
            this.setKeepAlive(false);
            return null;
        }
        return line;
    }

    public void writeRequest(HttpRequest request) throws IOException {
        if (request == null) {
            return;
        }
        ResponseWriter writer = new ResponseWriter(this.out, this.encoding);
        writer.println(request.getRequestLine().toString());
        Iterator<?> item = request.getHeaderIterator();
        while (item.hasNext()) {
            Header header = (Header)item.next();
            writer.print(header.toExternalForm());
        }
        writer.println();
        writer.flush();
        OutputStream outstream = this.out;
        InputStream content = request.getBody();
        if (content != null) {
            Header transferenc = request.getFirstHeader("Transfer-Encoding");
            if (transferenc != null) {
                request.removeHeaders("Content-Length");
                if (transferenc.getValue().indexOf("chunked") != -1) {
                    outstream = new ChunkedOutputStream(outstream);
                }
            }
            IOUtils.copy((InputStream)content, (OutputStream)outstream);
            if (outstream instanceof ChunkedOutputStream) {
                ((ChunkedOutputStream)outstream).finish();
            }
        }
        outstream.flush();
    }

    public void writeResponse(HttpResponse response) throws IOException {
        this.writeResponse(response, new HashMap<String, String>());
    }

    public void writeResponse(HttpResponse response, Map<String, String> headers) throws IOException {
        if (response == null) {
            return;
        }
        if (!response.isKeepAlive()) {
            Header header = new Header("Connection", "close");
            response.setHeader(header);
        }
        this.setKeepAlive(response.isKeepAlive());
        this.addHeadersToHttpResponse(response, headers);
        ResponseWriter writer = new ResponseWriter(this.out, this.encoding);
        OutputStream outstream = this.out;
        writer.println(response.getStatusLine());
        Iterator item = response.getHeaderIterator();
        while (item.hasNext()) {
            Header header = (Header)item.next();
            writer.print(header.toExternalForm());
        }
        writer.println();
        writer.flush();
        OutputHandler content = response.getBody();
        if (content != null) {
            Header transferenc = response.getFirstHeader("Transfer-Encoding");
            if (transferenc != null) {
                response.removeHeaders("Content-Length");
                if (transferenc.getValue().indexOf("chunked") != -1) {
                    outstream = new ChunkedOutputStream(outstream);
                }
            }
            content.write(RequestContext.getEvent(), outstream);
            if (outstream instanceof ChunkedOutputStream) {
                ((ChunkedOutputStream)outstream).finish();
            }
        }
        outstream.flush();
    }

    public String getUrlWithoutRequestParams() throws IOException {
        return this.readRequest().getUrlWithoutParams();
    }

    public String getRemoteClientAddress() {
        SocketAddress clientAddress = this.socket.getRemoteSocketAddress();
        if (clientAddress != null) {
            return clientAddress.toString();
        }
        return null;
    }

    public void writeFailureResponse(int statusCode, String description) throws IOException {
        this.writeFailureResponse(statusCode, description, new HashMap<String, String>());
    }

    public void writeFailureResponse(int statusCode, String description, Map<String, String> headers) throws IOException {
        HttpResponse response = new HttpResponse();
        response.setStatusLine(this.readRequest().getRequestLine().getHttpVersion(), statusCode);
        response.setBody(description);
        this.addHeadersToHttpResponse(response, headers);
        this.writeResponse(response);
    }

    private void addHeadersToHttpResponse(HttpResponse response, Map<String, String> headers) {
        for (String headerName : headers.keySet()) {
            response.addHeader(new Header(headerName, headers.get(headerName)));
        }
    }

    public String getFullUri() throws IOException {
        String scheme = "http";
        if (this.socket instanceof SSLSocket) {
            scheme = "https";
        }
        InetSocketAddress localSocketAddress = (InetSocketAddress)this.socket.getLocalSocketAddress();
        return String.format("%s://%s:%d%s", scheme, localSocketAddress.getHostName(), localSocketAddress.getPort(), this.readRequest().getUrlWithoutParams());
    }

    public int getSocketTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    public void setSocketTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    public Latch getSslSocketHandshakeCompleteLatch() {
        if (!(this.socket instanceof SSLSocket)) {
            throw new IllegalStateException("The socket type is not SSL");
        }
        return this.sslSocketHandshakeComplete;
    }

    public void reset() {
        this.requestLine = null;
        this.cachedRequest = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
        try {
            this.localCertificateChain = handshakeCompletedEvent.getLocalCertificates();
            try {
                this.peerCertificateChain = handshakeCompletedEvent.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                logger.debug((Object)("Cannot get peer certificate chain: " + e.getMessage()));
            }
        }
        finally {
            this.sslSocketHandshakeComplete.release();
        }
    }

    public Certificate[] getLocalCertificateChain() {
        if (!(this.socket instanceof SSLSocket)) {
            throw new IllegalStateException("The socket type is not SSL");
        }
        return this.localCertificateChain;
    }

    public Certificate[] getPeerCertificateChain() {
        if (!(this.socket instanceof SSLSocket)) {
            throw new IllegalStateException("The socket type is not SSL");
        }
        return this.peerCertificateChain;
    }

    public RequestLine getRequestLine() throws IOException {
        String line;
        if (this.requestLine == null && (line = this.readLine()) != null) {
            this.requestLine = RequestLine.parseLine(line);
        }
        return this.requestLine;
    }
}

