/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.util.concurrent.TimeUnit;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.context.WorkManager;
import org.mule.transport.http.HttpMessageProcessTemplate;
import org.mule.transport.http.HttpMessageReceiver;
import org.mule.transport.http.HttpServerConnection;
import org.mule.transport.http.HttpsConnector;
import org.mule.transport.http.i18n.HttpMessages;

public class HttpsMessageProcessTemplate
extends HttpMessageProcessTemplate {
    public HttpsMessageProcessTemplate(HttpMessageReceiver messageReceiver, HttpServerConnection httpServerConnection, WorkManager flowExecutionWorkManager) {
        super(messageReceiver, httpServerConnection, flowExecutionWorkManager);
    }

    @Override
    public MuleEvent beforeRouteEvent(MuleEvent muleEvent) throws MuleException {
        try {
            long timeout = ((HttpsConnector)this.getConnector()).getSslHandshakeTimeout();
            boolean handshakeComplete = this.getHttpServerConnection().getSslSocketHandshakeCompleteLatch().await(timeout, TimeUnit.MILLISECONDS);
            if (!handshakeComplete) {
                throw new MessagingException(HttpMessages.sslHandshakeDidNotComplete(), muleEvent);
            }
        }
        catch (InterruptedException e) {
            throw new MessagingException(HttpMessages.sslHandshakeDidNotComplete(), muleEvent, (Throwable)e);
        }
        if (this.getHttpServerConnection().getPeerCertificateChain() != null) {
            muleEvent.getMessage().setOutboundProperty("PEER_CERTIFICATES", (Object)this.getHttpServerConnection().getPeerCertificateChain());
        }
        if (this.getHttpServerConnection().getLocalCertificateChain() != null) {
            muleEvent.getMessage().setOutboundProperty("LOCAL_CERTIFICATES", (Object)this.getHttpServerConnection().getLocalCertificateChain());
        }
        super.beforeRouteEvent(muleEvent);
        return muleEvent;
    }
}

