/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerException;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.FixedAttribute;
import net.sf.saxon.instruct.FixedElement;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TraceExpression;
import net.sf.saxon.instruct.UseAttributeSets;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Validation;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.TreeBuilder;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.EmptySequence;

public class LiteralResultElement
extends StyleElement {
    private int resultNameCode;
    private int[] attributeNames;
    private Expression[] attributeValues;
    private int numberOfAttributes;
    private boolean toplevel;
    private int[] namespaceCodes;
    private AttributeSet[] attributeSets;
    private SchemaType schemaType = null;
    private int validation = 4;
    private boolean inheritNamespaces = true;

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        int n = this.attributeList.getLength();
        if (n == 0) {
            this.numberOfAttributes = 0;
        } else {
            NamePool namePool = this.getNamePool();
            this.attributeNames = new int[n];
            this.attributeValues = new Expression[n];
            this.numberOfAttributes = 0;
            for (int i = 0; i < n; ++i) {
                Expression expression;
                int n2 = this.attributeList.getNameCode(i);
                short s = namePool.getURICode(n2);
                if (s == 2) {
                    int n3 = n2 & 0xFFFFF;
                    if (n3 == 233 || n3 == 228 || n3 == 230 || n3 == 229 || n3 == 236 || n3 == 237 || n3 == 232 || n3 == 234 || n3 == 235) continue;
                    if (n3 == 231) {
                        String string = this.attributeList.getValue(i);
                        if (string.equals("yes")) {
                            this.inheritNamespaces = true;
                            continue;
                        }
                        if (string.equals("no")) {
                            this.inheritNamespaces = false;
                            continue;
                        }
                        this.compileError("The xsl:inherit-namespaces attribute has permitted values (yes, no)", "XTSE0020");
                        continue;
                    }
                    this.compileError("Unknown XSL attribute " + namePool.getDisplayName(n2), "XTSE0805");
                    continue;
                }
                this.attributeNames[this.numberOfAttributes] = n2;
                this.attributeValues[this.numberOfAttributes] = expression = this.makeAttributeValueTemplate(this.attributeList.getValue(i));
                ++this.numberOfAttributes;
            }
            if (this.numberOfAttributes < this.attributeNames.length) {
                int[] nArray = new int[this.numberOfAttributes];
                System.arraycopy(this.attributeNames, 0, nArray, 0, this.numberOfAttributes);
                this.attributeNames = nArray;
                Expression[] expressionArray = new Expression[this.numberOfAttributes];
                System.arraycopy(this.attributeValues, 0, expressionArray, 0, this.numberOfAttributes);
                this.attributeValues = expressionArray;
            }
        }
    }

    public void validate() throws XPathException {
        this.toplevel = this.getParent() instanceof XSLStylesheet;
        this.resultNameCode = this.getNameCode();
        NamePool namePool = this.getNamePool();
        short s = namePool.getURICode(this.resultNameCode);
        if (this.toplevel) {
            if (s == 0) {
                this.compileError("Top level elements must have a non-null namespace URI", "XTSE0130");
            }
        } else {
            int n;
            int n2;
            int n3;
            int n4;
            String string;
            String string2;
            boolean bl = false;
            NodeInfo nodeInfo = this.getParent();
            if (nodeInfo instanceof LiteralResultElement && ((LiteralResultElement)nodeInfo).inheritNamespaces && (this.namespaceList == null || this.namespaceList.length == 0) && s == namePool.getURICode(this.getParent().getFingerprint())) {
                bl = true;
            }
            if (bl) {
                for (int i = 0; i < this.attributeList.getLength(); ++i) {
                    if (NamePool.getPrefixIndex(this.attributeList.getNameCode(i)) == 0) continue;
                    bl = false;
                    break;
                }
            }
            this.namespaceCodes = bl ? NodeInfo.EMPTY_NAMESPACE_LIST : this.getInScopeNamespaceCodes();
            XSLStylesheet xSLStylesheet = this.getPrincipalStylesheet();
            if (xSLStylesheet.hasNamespaceAliases()) {
                int n5;
                for (n5 = 0; n5 < this.namespaceCodes.length; ++n5) {
                    short s2 = (short)(this.namespaceCodes[n5] & 0xFFFF);
                    int n6 = xSLStylesheet.getNamespaceAlias(s2);
                    if (n6 == -1 || (n6 & 0xFFFF) == s2) continue;
                    this.namespaceCodes[n5] = n6;
                }
                n5 = xSLStylesheet.getNamespaceAlias(s);
                if ((n5 & 0xFFFF) != s) {
                    this.resultNameCode = namePool.allocate(namePool.getPrefixFromNamespaceCode(n5), namePool.getURIFromNamespaceCode(n5), this.getLocalPart());
                }
            }
            if ((string2 = this.getAttributeValue(233)) != null) {
                this.attributeSets = this.getAttributeSets(string2, null);
            }
            this.validation = this.getContainingStylesheet().getDefaultValidation();
            String string3 = this.getAttributeValue(232);
            if (string3 != null) {
                if (!this.getConfiguration().isSchemaAware(50)) {
                    this.compileError("The xsl:type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
                }
                this.schemaType = this.getSchemaType(string3);
                this.validation = 8;
            }
            if ((string = this.getAttributeValue(235)) != null) {
                this.validation = Validation.getCode(string);
                if (this.validation != 4 && !this.getConfiguration().isSchemaAware(50)) {
                    this.compileError("To perform validation, a schema-aware XSLT processor is needed", "XTSE1660");
                }
                if (this.validation == -1) {
                    this.compileError("Invalid value for xsl:validation. Permitted values are (strict, lax, preserve, strip)", "XTSE0020");
                }
                if (this.schemaType != null) {
                    this.compileError("The attributes xsl:type and xsl:validation are mutually exclusive", "XTSE1505");
                }
            }
            short[] sArray = new short[this.numberOfAttributes];
            if (this.numberOfAttributes > 0) {
                for (n4 = 0; n4 < this.numberOfAttributes; ++n4) {
                    int n7;
                    n2 = n3 = this.attributeNames[n4];
                    n = namePool.getURICode(n3);
                    if (n != 0 && ((n7 = xSLStylesheet.getNamespaceAlias((short)n)) & 0xFFFF) != n) {
                        n = (short)(n7 & 0xFFFF);
                        n2 = namePool.allocate(namePool.getPrefixFromNamespaceCode(n7), namePool.getURIFromNamespaceCode(n7), this.attributeList.getLocalName(n4));
                    }
                    this.attributeNames[n4] = n2;
                    sArray[n4] = n;
                    this.attributeValues[n4] = this.typeCheck(namePool.getDisplayName(n2), this.attributeValues[n4]);
                }
            }
            n4 = 0;
            for (n3 = 0; n3 < this.namespaceCodes.length; ++n3) {
                n2 = (short)(this.namespaceCodes[n3] & 0xFFFF);
                if (!this.isExcludedNamespace((short)n2) || xSLStylesheet.isAliasResultNamespace((short)n2)) continue;
                this.namespaceCodes[n3] = -1;
                ++n4;
            }
            n3 = this.namespaceCodes.length - n4;
            int[] nArray = new int[n3];
            n3 = 0;
            for (n = 0; n < this.namespaceCodes.length; ++n) {
                if (this.namespaceCodes[n] == -1) continue;
                nArray[n3++] = this.namespaceCodes[n];
            }
            this.namespaceCodes = nArray;
        }
    }

    protected void validateChildren() throws XPathException {
        if (!this.toplevel) {
            super.validateChildren();
        }
    }

    public Expression compile(Executable executable) throws XPathException {
        if (this.toplevel) {
            return null;
        }
        FixedElement fixedElement = new FixedElement(this.resultNameCode, this.namespaceCodes, this.inheritNamespaces, this.schemaType, this.validation);
        fixedElement.setBaseURI(this.getBaseURI());
        Expression expression = this.compileSequenceConstructor(executable, this.iterateAxis((byte)3), true);
        Expression.setParentExpression(expression, fixedElement);
        if (this.numberOfAttributes > 0) {
            for (int i = this.attributeNames.length - 1; i >= 0; --i) {
                FixedAttribute fixedAttribute = new FixedAttribute(this.attributeNames[i], 4, null, 631);
                try {
                    fixedAttribute.setSelect(this.attributeValues[i], executable.getConfiguration());
                }
                catch (XPathException xPathException) {
                    this.compileError(xPathException);
                }
                fixedAttribute.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
                fixedAttribute.setParentExpression(fixedElement);
                ExpressionTool.makeParentReferences(fixedAttribute);
                Instruction instruction = fixedAttribute;
                if (this.getConfiguration().isCompileWithTracing()) {
                    TraceExpression traceExpression = new TraceExpression(instruction);
                    traceExpression.setLineNumber(this.getLineNumber());
                    traceExpression.setColumnNumber(-1);
                    traceExpression.setSystemId(this.getSystemId());
                    traceExpression.setNamespaceResolver(this.getNamespaceResolver());
                    traceExpression.setConstructType(2007);
                    traceExpression.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
                    traceExpression.setObjectNameCode(this.attributeNames[i]);
                    traceExpression.setParentExpression(fixedElement);
                    instruction = traceExpression;
                }
                if (expression == null) {
                    expression = instruction;
                    continue;
                }
                expression = Block.makeBlock(instruction, expression);
                expression.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            }
        }
        if (this.attributeSets != null) {
            UseAttributeSets useAttributeSets = new UseAttributeSets(this.attributeSets);
            if (expression == null) {
                expression = useAttributeSets;
            } else {
                expression = Block.makeBlock(useAttributeSets, expression);
                expression.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            }
        }
        if (expression == null) {
            expression = Literal.makeLiteral(EmptySequence.getInstance());
        }
        fixedElement.setContentExpression(expression);
        ExpressionTool.makeParentReferences(fixedElement);
        return fixedElement;
    }

    public DocumentImpl makeStylesheet(PreparedStylesheet preparedStylesheet, StyleNodeFactory styleNodeFactory) throws XPathException {
        NamePool namePool = this.getNamePool();
        String string = this.getPrefixForURI("http://www.w3.org/1999/XSL/Transform");
        if (string == null) {
            String string2 = this.getLocalPart().equals("stylesheet") || this.getLocalPart().equals("transform") ? (this.getPrefixForURI("http://www.w3.org/TR/WD-xsl") != null ? "Saxon is not able to process Microsoft's WD-xsl dialect" : "Namespace for stylesheet element should be http://www.w3.org/1999/XSL/Transform") : "The supplied file does not appear to be a stylesheet";
            StaticError staticError = new StaticError(string2);
            staticError.setLocator(this);
            staticError.setErrorCode("XTSE0165");
            try {
                preparedStylesheet.reportError(staticError);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            throw staticError;
        }
        String string3 = this.getAttributeValue(236);
        if (string3 == null) {
            StaticError staticError = new StaticError("Simplified stylesheet: xsl:version attribute is missing");
            staticError.setErrorCode("XTSE0150");
            staticError.setLocator(this);
            try {
                preparedStylesheet.reportError(staticError);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            throw staticError;
        }
        try {
            TreeBuilder treeBuilder = new TreeBuilder();
            treeBuilder.setPipelineConfiguration(preparedStylesheet.getConfiguration().makePipelineConfiguration());
            treeBuilder.setNodeFactory(styleNodeFactory);
            treeBuilder.setSystemId(this.getSystemId());
            treeBuilder.open();
            treeBuilder.startDocument(0);
            int n = 180;
            treeBuilder.startElement(n, 630, 0, 0);
            treeBuilder.namespace(2, 0);
            treeBuilder.attribute(namePool.allocate("", "", "version"), 631, string3, 0, 0);
            treeBuilder.startContent();
            int n2 = 181;
            treeBuilder.startElement(n2, 630, 0, 0);
            treeBuilder.attribute(namePool.allocate("", "", "match"), 631, "/", 0, 0);
            treeBuilder.startContent();
            treeBuilder.graftElement(this);
            treeBuilder.endElement();
            treeBuilder.endElement();
            treeBuilder.endDocument();
            treeBuilder.close();
            return (DocumentImpl)treeBuilder.getCurrentRoot();
        }
        catch (XPathException xPathException) {
            xPathException.setLocator(this);
            throw xPathException;
        }
    }

    public int getConstructType() {
        return 2006;
    }

    public int getObjectNameCode() {
        return this.resultNameCode;
    }

    public Object getProperty(String string) {
        if (string.equals("name")) {
            return this.getDisplayName();
        }
        return null;
    }
}

