/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.module.launcher.AbstractDeploymentListener;

public class DeploymentStatusTracker
extends AbstractDeploymentListener {
    protected Map<String, DeploymentState> deploymentStates = new ConcurrentHashMap<String, DeploymentState>();

    public Map<String, DeploymentState> getDeploymentStates() {
        return Collections.unmodifiableMap(this.deploymentStates);
    }

    @Override
    public void onDeploymentStart(String appName) {
        this.deploymentStates.put(appName, DeploymentState.DEPLOYING);
    }

    @Override
    public void onDeploymentSuccess(String appName) {
        this.deploymentStates.put(appName, DeploymentState.DEPLOYED);
    }

    @Override
    public void onDeploymentFailure(String appName, Throwable failureCause) {
        this.deploymentStates.put(appName, DeploymentState.FAILED);
    }

    public static enum DeploymentState {
        DEPLOYING,
        FAILED,
        DEPLOYED;

    }
}

