/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.application;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.module.launcher.application.ApplicationClassLoader;
import org.mule.module.launcher.application.EnumerationAdapter;

public class CompositeApplicationClassLoader
extends ClassLoader
implements ApplicationClassLoader,
Closeable {
    protected static final Log logger = LogFactory.getLog(CompositeApplicationClassLoader.class);
    private final List<ClassLoader> classLoaders;
    private final String appName;

    public CompositeApplicationClassLoader(String appName, List<ClassLoader> classLoaders) {
        this.appName = appName;
        this.classLoaders = new LinkedList<ClassLoader>(classLoaders);
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public Class<?> loadClass(String s) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.classLoaders) {
            try {
                Class<?> aClass = classLoader.loadClass(s);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Class '%s' loaded from classLoader '%s", s, classLoader));
                }
                return aClass;
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException(String.format("Cannot load class '%s'", s));
    }

    @Override
    protected synchronized Class<?> loadClass(String s, boolean b) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.classLoaders) {
            try {
                Class<?> aClass = this.loadClass(classLoader, s, b);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Class '%s' loaded from classLoader '%s", s, classLoader));
                }
                return aClass;
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException(String.format("Cannot load class '%s'", s));
    }

    protected Class<?> loadClass(ClassLoader classLoader, String s, boolean b) throws ClassNotFoundException {
        try {
            Method loadClassMethod = this.findDeclaredMethod(classLoader, "loadClass", String.class, Boolean.TYPE);
            return (Class)loadClassMethod.invoke((Object)classLoader, s, b);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Error loading class '%s' from classloader '%s'", s, classLoader), (Throwable)e);
            }
            throw new ClassNotFoundException(String.format("Cannot load class '%s'", s));
        }
    }

    @Override
    public URL getResource(String s) {
        for (ClassLoader classLoader : this.classLoaders) {
            URL resource = classLoader.getResource(s);
            if (resource == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Resource '%s' loaded from classLoader '%s", s, classLoader));
            }
            return resource;
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String s) {
        for (ClassLoader classLoader : this.classLoaders) {
            InputStream resourceAsStream = classLoader.getResourceAsStream(s);
            if (resourceAsStream == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Stream resource '%s' loaded from classLoader '%s", s, classLoader));
            }
            return resourceAsStream;
        }
        return null;
    }

    @Override
    protected String findLibrary(String s) {
        for (ClassLoader classLoader : this.classLoaders) {
            String library = this.findLibrary(s, classLoader);
            if (library == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Library '%s' found in classLoader '%s", s, classLoader));
            }
            return library;
        }
        return null;
    }

    protected String findLibrary(String s, ClassLoader classLoader) {
        try {
            Method findLibraryMethod = this.findDeclaredMethod(classLoader, "findLibrary", String.class);
            return (String)findLibraryMethod.invoke((Object)classLoader, s);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Error finding library '%s' in classloader '%s'", s, classLoader), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public Enumeration<URL> getResources(String s) throws IOException {
        HashMap<String, URL> resources = new HashMap<String, URL>();
        for (ClassLoader classLoader : this.classLoaders) {
            Enumeration<URL> partialResources = classLoader.getResources(s);
            while (partialResources.hasMoreElements()) {
                URL url = partialResources.nextElement();
                if (resources.get(url.toString()) != null) continue;
                resources.put(url.toString(), url);
            }
        }
        return new EnumerationAdapter<URL>(resources.values());
    }

    @Override
    public URL findResource(String s) {
        for (ClassLoader classLoader : this.classLoaders) {
            URL resource = this.findResource(classLoader, s);
            if (resource == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Resource '%s' loaded from classLoader '%s", s, classLoader));
            }
            return resource;
        }
        return null;
    }

    @Override
    public void close() {
        for (ClassLoader classLoader : this.classLoaders) {
            if (!(classLoader instanceof Closeable)) continue;
            try {
                ((Closeable)((Object)classLoader)).close();
            }
            catch (IOException iOException) {}
        }
    }

    private URL findResource(ClassLoader classLoader, String s) {
        try {
            Method findResourceMethod = this.findDeclaredMethod(classLoader, "findResource", String.class);
            return (URL)findResourceMethod.invoke((Object)classLoader, s);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Error finding resource '%s' in classloader '%s'", s, classLoader), (Throwable)e);
            }
            return null;
        }
    }

    private Method findDeclaredMethod(ClassLoader classLoader, String methodName, Class<?> ... params) throws NoSuchMethodException {
        for (Class<?> clazz = classLoader.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Method findLibraryMethod = clazz.getDeclaredMethod(methodName, params);
                findLibraryMethod.setAccessible(true);
                return findLibraryMethod;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        throw new NoSuchMethodException(String.format("Cannot find a method '%s' with the given parameter types '%s'", methodName, Arrays.toString(params)));
    }
}

