/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.coreextension;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleCoreExtension;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.module.launcher.DeploymentListener;
import org.mule.module.launcher.DeploymentService;
import org.mule.module.launcher.DeploymentServiceAware;
import org.mule.module.launcher.PluginClassLoaderManager;
import org.mule.module.launcher.PluginClassLoaderManagerAware;
import org.mule.module.launcher.coreextension.ClasspathMuleCoreExtensionDiscoverer;
import org.mule.module.launcher.coreextension.MuleCoreExtensionDependencyResolver;
import org.mule.module.launcher.coreextension.MuleCoreExtensionDiscoverer;
import org.mule.module.launcher.coreextension.MuleCoreExtensionManager;
import org.mule.module.launcher.coreextension.ReflectionMuleCoreExtensionDependencyResolver;

public class DefaultMuleCoreExtensionManager
implements MuleCoreExtensionManager {
    protected static final Log logger = LogFactory.getLog(DefaultMuleCoreExtensionManager.class);
    private final MuleCoreExtensionDiscoverer coreExtensionDiscoverer;
    private final MuleCoreExtensionDependencyResolver coreExtensionDependencyResolver;
    private List<MuleCoreExtension> coreExtensions = new LinkedList<MuleCoreExtension>();
    private DeploymentService deploymentService;
    private List<MuleCoreExtension> orderedCoreExtensions;
    private PluginClassLoaderManager pluginClassLoaderManager;

    public DefaultMuleCoreExtensionManager() {
        this(new ClasspathMuleCoreExtensionDiscoverer(), new ReflectionMuleCoreExtensionDependencyResolver());
    }

    public DefaultMuleCoreExtensionManager(MuleCoreExtensionDiscoverer coreExtensionDiscoverer, MuleCoreExtensionDependencyResolver coreExtensionDependencyResolver) {
        this.coreExtensionDiscoverer = coreExtensionDiscoverer;
        this.coreExtensionDependencyResolver = coreExtensionDependencyResolver;
    }

    public void dispose() {
        for (MuleCoreExtension extension : this.coreExtensions) {
            try {
                extension.dispose();
            }
            catch (Exception ex) {
                logger.fatal((Object)("Error disposing core extension " + extension.getName()), (Throwable)ex);
            }
        }
    }

    public void initialise() throws InitialisationException {
        try {
            this.coreExtensions = this.coreExtensionDiscoverer.discover();
            this.orderedCoreExtensions = this.coreExtensionDependencyResolver.resolveDependencies(this.coreExtensions);
            this.initializeCoreExtensions();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public void start() throws MuleException {
        logger.info((Object)"Starting core extensions");
        for (MuleCoreExtension extension : this.orderedCoreExtensions) {
            extension.start();
        }
    }

    public void stop() throws MuleException {
        if (this.orderedCoreExtensions == null) {
            return;
        }
        for (int i = this.orderedCoreExtensions.size() - 1; i >= 0; --i) {
            MuleCoreExtension extension = this.orderedCoreExtensions.get(i);
            try {
                extension.stop();
                continue;
            }
            catch (MuleException e) {
                logger.warn((Object)("Error stopping core extension: " + extension.getName()), (Throwable)e);
            }
        }
    }

    private void initializeCoreExtensions() throws InitialisationException, DefaultMuleException {
        logger.info((Object)"Initializing core extensions");
        for (MuleCoreExtension extension : this.coreExtensions) {
            if (extension instanceof DeploymentServiceAware) {
                ((DeploymentServiceAware)extension).setDeploymentService(this.deploymentService);
            }
            if (extension instanceof DeploymentListener) {
                this.deploymentService.addDeploymentListener((DeploymentListener)extension);
            }
            if (extension instanceof PluginClassLoaderManagerAware) {
                ((PluginClassLoaderManagerAware)extension).setPluginClassLoaderManager(this.pluginClassLoaderManager);
            }
            extension.initialise();
        }
    }

    @Override
    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    @Override
    public void setPluginClassLoaderManager(PluginClassLoaderManager pluginClassLoaderManager) {
        this.pluginClassLoaderManager = pluginClassLoaderManager;
    }
}

