/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.components.crypto;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CRL;
import java.util.Collections;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.components.crypto.CredentialException;
import org.apache.ws.security.components.crypto.Merlin;

public class MerlinDevice
extends Merlin {
    private static final Log log = LogFactory.getLog(MerlinDevice.class);
    private static final boolean doDebug = log.isDebugEnabled();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void loadProperties(Properties properties, ClassLoader loader) throws CredentialException, IOException {
        if (properties == null) {
            return;
        }
        this.properties = properties;
        provider = properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.provider");
        if (provider != null) {
            provider = provider.trim();
        }
        if ((certProvider = properties.getProperty("org.apache.ws.security.crypto.merlin.cert.provider")) != null) {
            this.setCryptoProvider(certProvider);
        }
        if ((alias = properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.alias")) != null) {
            this.defaultAlias = alias = alias.trim();
        }
        if ((keyStoreLocation = properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.file")) == null) {
            keyStoreLocation = properties.getProperty("org.apache.ws.security.crypto.merlin.file");
        }
        if ((keyStorePassword = properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.password", "security")) != null) {
            keyStorePassword = keyStorePassword.trim();
        }
        if ((keyStoreType = properties.getProperty("org.apache.ws.security.crypto.merlin.keystore.type", KeyStore.getDefaultType())) != null) {
            keyStoreType = keyStoreType.trim();
        }
        if (keyStoreLocation != null) {
            keyStoreLocation = keyStoreLocation.trim();
            is = MerlinDevice.loadInputStream(loader, keyStoreLocation);
            try {
                this.keystore = this.load(is, keyStorePassword, provider, keyStoreType);
                if (!MerlinDevice.doDebug) ** GOTO lbl30
                MerlinDevice.log.debug((Object)("The KeyStore " + keyStoreLocation + " of type " + keyStoreType + " has been loaded"));
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        } else {
            this.keystore = this.load(null, keyStorePassword, provider, keyStoreType);
        }
lbl30:
        // 3 sources

        if ((trustStorePassword = properties.getProperty("org.apache.ws.security.crypto.merlin.truststore.password", "changeit")) != null) {
            trustStorePassword = trustStorePassword.trim();
        }
        if ((trustStoreType = properties.getProperty("org.apache.ws.security.crypto.merlin.truststore.type", KeyStore.getDefaultType())) != null) {
            trustStoreType = trustStoreType.trim();
        }
        if ((loadCacerts = properties.getProperty("org.apache.ws.security.crypto.merlin.load.cacerts", "false")) != null) {
            loadCacerts = loadCacerts.trim();
        }
        if ((trustStoreLocation = properties.getProperty("org.apache.ws.security.crypto.merlin.truststore.file")) != null) {
            trustStoreLocation = trustStoreLocation.trim();
            is = MerlinDevice.loadInputStream(loader, trustStoreLocation);
            try {
                this.truststore = this.load(is, trustStorePassword, provider, trustStoreType);
                if (MerlinDevice.doDebug) {
                    MerlinDevice.log.debug((Object)("The TrustStore " + trustStoreLocation + " of type " + trustStoreType + " has been loaded"));
                }
                this.loadCACerts = false;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        } else if (Boolean.valueOf(loadCacerts).booleanValue()) {
            cacertsPath = System.getProperty("java.home") + "/lib/security/cacerts";
            if (cacertsPath != null) {
                cacertsPath = cacertsPath.trim();
            }
            is = new FileInputStream(cacertsPath);
            try {
                cacertsPasswd = properties.getProperty("org.apache.ws.security.crypto.merlin.truststore.password", "changeit");
                if (cacertsPasswd != null) {
                    cacertsPasswd = cacertsPasswd.trim();
                }
                this.truststore = this.load(is, cacertsPasswd, null, KeyStore.getDefaultType());
                if (MerlinDevice.doDebug) {
                    MerlinDevice.log.debug((Object)"CA certs have been loaded");
                }
                this.loadCACerts = true;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        } else {
            this.truststore = this.load(null, trustStorePassword, provider, trustStorePassword);
        }
        if ((crlLocation = properties.getProperty("org.apache.ws.security.crypto.merlin.x509crl.file")) != null) {
            crlLocation = crlLocation.trim();
            is = MerlinDevice.loadInputStream(loader, crlLocation);
            try {
                cf = this.getCertificateFactory();
                crl = (X509CRL)cf.generateCRL(is);
                this.crlCertStore = provider == null || provider.length() == 0 ? CertStore.getInstance("Collection", new CollectionCertStoreParameters(Collections.singletonList(crl))) : CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(Collections.singletonList(crl)), provider);
                if (MerlinDevice.doDebug) {
                    MerlinDevice.log.debug((Object)("The CRL " + crlLocation + " has been loaded"));
                }
            }
            catch (Exception e) {
                if (MerlinDevice.doDebug) {
                    MerlinDevice.log.debug((Object)e.getMessage(), (Throwable)e);
                }
                throw new CredentialException(3, "ioError00", e);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
    }
}

