/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Store;
import javax.mail.event.MessageCountEvent;
import javax.mail.event.MessageCountListener;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connector;
import org.mule.api.transport.ReceiveException;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.email.AbstractRetrieveMailConnector;
import org.mule.transport.email.SessionDetails;
import org.mule.transport.email.i18n.EmailMessages;
import org.mule.util.FileUtils;
import org.mule.util.StringUtils;
import org.mule.util.UUID;

public class RetrieveMessageReceiver
extends AbstractPollingMessageReceiver
implements MessageCountListener {
    private Folder folder = null;
    private Folder moveToFolder = null;
    private boolean backupEnabled;
    private String backupFolder = null;
    private final Object folderLock = new Object();

    public RetrieveMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint, long checkFrequency, boolean backupEnabled, String backupFolder) throws CreateException {
        super(connector, flowConstruct, endpoint);
        this.backupFolder = backupFolder;
        this.backupEnabled = backupEnabled;
        this.setFrequency(checkFrequency);
    }

    private AbstractRetrieveMailConnector castConnector() {
        return (AbstractRetrieveMailConnector)this.getConnector();
    }

    protected void doConnect() throws Exception {
        SessionDetails session = this.castConnector().getSessionDetails(this.endpoint);
        Store store = session.newStore();
        store.connect();
        this.folder = store.getFolder(this.castConnector().getMailboxFolder());
        if (this.castConnector().getMoveToFolder() != null) {
            this.moveToFolder = store.getFolder(this.castConnector().getMoveToFolder());
            this.moveToFolder.open(2);
        }
        if (StringUtils.isEmpty((String)this.backupFolder)) {
            this.backupFolder = this.connector.getMuleContext().getConfiguration().getWorkingDirectory() + "/mail/" + this.folder.getName();
        }
        if (this.backupFolder != null && !this.backupFolder.endsWith(File.separator)) {
            this.backupFolder = this.backupFolder + File.separator;
        }
    }

    protected void doDisconnect() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() {
        Object object = this.folderLock;
        synchronized (object) {
            if (this.folder != null) {
                this.folder.removeMessageCountListener((MessageCountListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws MuleException {
        super.doStart();
        Object object = this.folderLock;
        synchronized (object) {
            this.folder.addMessageCountListener((MessageCountListener)this);
        }
    }

    public void messagesAdded(MessageCountEvent event) {
        block17: {
            try {
                Message[] messages = event.getMessages();
                ArrayList<Message> processedMessages = new ArrayList<Message>();
                if (messages == null) break block17;
                MuleMessage message = null;
                for (int i = 0; i < messages.length && !this.getLifecycleState().isStopping() && !this.getLifecycleState().isStopped(); ++i) {
                    try {
                        if (messages[i].getFlags().contains(Flags.Flag.DELETED) || messages[i].getFlags().contains(Flags.Flag.SEEN)) continue;
                        try {
                            MimeMessage mimeMessage = new MimeMessage((MimeMessage)messages[i]);
                            this.storeMessage((Message)mimeMessage);
                            message = this.createMuleMessage(mimeMessage, this.endpoint.getEncoding());
                            if (this.castConnector().isDeleteReadMessages()) {
                                if (this.moveToFolder != null) {
                                    this.folder.copyMessages(new Message[]{messages[i]}, this.moveToFolder);
                                }
                                messages[i].setFlag(Flags.Flag.DELETED, true);
                            } else if (this.getEndpoint().getFilter() != null && this.getEndpoint().getFilter().accept(message)) {
                                Flags.Flag flag = this.castConnector().getDefaultProcessMessageAction();
                                if (flag != null) {
                                    if (flag == Flags.Flag.DELETED && this.moveToFolder != null) {
                                        this.folder.copyMessages(new Message[]{messages[i]}, this.moveToFolder);
                                    }
                                    messages[i].setFlag(flag, true);
                                }
                            } else {
                                messages[i].setFlag(Flags.Flag.SEEN, true);
                                processedMessages.add(messages[i]);
                            }
                            this.routeMessage(message);
                            continue;
                        }
                        catch (MessagingException e) {
                            continue;
                        }
                        catch (Exception e) {
                            this.connector.getMuleContext().getExceptionListener().handleException(e);
                            throw e;
                        }
                    }
                    catch (MuleException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        MessagingException forwarded = message != null ? new MessagingException(EmailMessages.routingError(), message, (Throwable)e) : new ReceiveException(this.endpoint, -1L, (Throwable)e);
                        throw forwarded;
                    }
                }
                if (this.moveToFolder != null) {
                    this.folder.copyMessages(processedMessages.toArray(new Message[processedMessages.size()]), this.moveToFolder);
                }
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    public void messagesRemoved(MessageCountEvent event) {
        if (this.logger.isDebugEnabled()) {
            Message[] messages = event.getMessages();
            for (int i = 0; i < messages.length; ++i) {
                try {
                    this.logger.debug((Object)("Message removed: " + messages[i].getSubject()));
                    continue;
                }
                catch (javax.mail.MessagingException ignore) {
                    this.logger.debug((Object)("ignoring exception: " + ignore.getMessage()));
                }
            }
        }
    }

    public Folder getFolder() {
        return this.folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFolder(Folder folder) {
        Object object = this.folderLock;
        synchronized (object) {
            if (folder == null) {
                throw new IllegalArgumentException("Mail folder cannot be null");
            }
            this.folder = folder;
            if (!this.folder.isOpen()) {
                try {
                    this.folder.open(2);
                }
                catch (javax.mail.MessagingException e) {
                    this.logger.warn((Object)("Failed to open folder: " + folder.getFullName()), (Throwable)e);
                }
            }
        }
    }

    protected void storeMessage(Message msg) throws IOException, javax.mail.MessagingException {
        if (this.backupEnabled) {
            String filename = msg.getFileName();
            if (filename == null) {
                Address[] from = msg.getFrom();
                filename = from != null && from.length > 0 ? (from[0] instanceof InternetAddress ? ((InternetAddress)from[0]).getAddress() : from[0].toString()) : "(no from address)";
                filename = filename + "[" + UUID.getUUID() + "]";
            }
            filename = FileUtils.prepareWinFilename((String)filename);
            filename = this.backupFolder + filename + ".msg";
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Writing message to: " + filename));
            }
            File f = FileUtils.createFile((String)filename);
            FileOutputStream fos = new FileOutputStream(f);
            msg.writeTo((OutputStream)fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll() {
        boolean done = false;
        while (!done) {
            Object object = this.folderLock;
            synchronized (object) {
                if (this.getLifecycleState().isStopping() || this.getLifecycleState().isStopped()) {
                    break;
                }
                try {
                    block22: {
                        try {
                            if (!this.folder.isOpen()) {
                                this.folder.open(2);
                            }
                        }
                        catch (Exception e) {
                            if (!this.logger.isDebugEnabled()) break block22;
                            this.logger.debug((Object)("ignoring exception: " + e.getMessage()));
                        }
                    }
                    int count = this.folder.getMessageCount();
                    int batchSize = this.getBatchSize(count);
                    if (count > 0) {
                        Message[] messages = this.folder.getMessages(1, batchSize);
                        MessageCountEvent event = new MessageCountEvent(this.folder, 1, true, messages);
                        this.messagesAdded(event);
                    } else if (count == -1) {
                        throw new javax.mail.MessagingException("Cannot monitor folder: " + this.folder.getFullName() + " as folder is closed");
                    }
                    done = batchSize >= count;
                }
                catch (javax.mail.MessagingException e) {
                    done = true;
                    this.getConnector().getMuleContext().getExceptionListener().handleException((Exception)((Object)e));
                }
                finally {
                    try {
                        this.folder.close(true);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("Failed to close pop3  inbox: " + e.getMessage()));
                    }
                }
            }
        }
    }

    protected boolean pollOnPrimaryInstanceOnly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispose() {
        Object object = this.folderLock;
        synchronized (object) {
            if (null != this.folder) {
                this.folder.removeMessageCountListener((MessageCountListener)this);
                if (this.folder.isOpen()) {
                    try {
                        this.folder.close(true);
                    }
                    catch (Exception e) {
                        this.logger.debug((Object)("ignoring exception: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }
    }

    protected MuleMessage handleUnacceptedFilter(MuleMessage message) {
        super.handleUnacceptedFilter(message);
        if (message.getPayload() instanceof Message) {
            Message msg = (Message)message.getPayload();
            try {
                msg.setFlag(Flags.Flag.DELETED, this.endpoint.isDeleteUnacceptedMessages());
            }
            catch (javax.mail.MessagingException e) {
                this.logger.error((Object)("failed to set message deleted: " + e.getMessage()), (Throwable)e);
            }
        }
        return message;
    }
}

