/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.RuleBaseConfiguration;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.RuleBasePartitionId;
import org.drools.reteoo.LIANodePropagation;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.builder.BuildContext;
import org.drools.spi.PropagationContext;
import org.drools.util.RightTupleList;

public class LeftInputAdapterNode
extends LeftTupleSource
implements ObjectSinkNode,
NodeMemory {
    private static final long serialVersionUID = 400L;
    private ObjectSource objectSource;
    private ObjectSinkNode previousRightTupleSinkNode;
    private ObjectSinkNode nextRightTupleSinkNode;
    private boolean leftTupleMemoryEnabled;

    public LeftInputAdapterNode() {
    }

    public LeftInputAdapterNode(int id, ObjectSource source, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.objectSource = source;
        this.leftTupleMemoryEnabled = context.isTupleMemoryEnabled();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.objectSource = (ObjectSource)in.readObject();
        this.previousRightTupleSinkNode = (ObjectSinkNode)in.readObject();
        this.nextRightTupleSinkNode = (ObjectSinkNode)in.readObject();
        this.leftTupleMemoryEnabled = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.objectSource);
        out.writeObject(this.previousRightTupleSinkNode);
        out.writeObject(this.nextRightTupleSinkNode);
        out.writeBoolean(this.leftTupleMemoryEnabled);
    }

    public void attach() {
        this.objectSource.addObjectSink(this);
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        for (InternalWorkingMemory workingMemory : workingMemories) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.objectSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    public void networkUpdated() {
        this.objectSource.networkUpdated();
    }

    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (!workingMemory.isSequential()) {
            this.sink.createAndPropagateAssertLeftTuple(factHandle, context, workingMemory, this.leftTupleMemoryEnabled);
        } else {
            workingMemory.addLIANodePropagation(new LIANodePropagation(this, factHandle, context));
        }
    }

    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        RightTupleSinkAdapter adapter = new RightTupleSinkAdapter(sink, this.leftTupleMemoryEnabled);
        this.objectSource.updateSink(adapter, context, workingMemory);
    }

    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        context.visitTupleSource(this);
        if (!node.isInUse()) {
            this.removeTupleSink((LeftTupleSink)((Object)node));
        }
        if (!this.isInUse()) {
            int length = workingMemories.length;
            for (int i = 0; i < length; ++i) {
                workingMemories[i].clearNodeMemory(this);
            }
        }
        this.objectSource.remove(context, builder, this, workingMemories);
    }

    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextRightTupleSinkNode;
    }

    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextRightTupleSinkNode = next;
    }

    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousRightTupleSinkNode;
    }

    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousRightTupleSinkNode = previous;
    }

    public int hashCode() {
        return this.objectSource.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof LeftInputAdapterNode)) {
            return false;
        }
        LeftInputAdapterNode other = (LeftInputAdapterNode)object;
        return this.objectSource.equals(other.objectSource);
    }

    public Object createMemory(RuleBaseConfiguration config) {
        return new RightTupleList();
    }

    private static class RightTupleSinkAdapter
    implements ObjectSink {
        private LeftTupleSink sink;
        private boolean leftTupleMemoryEnabled;

        public RightTupleSinkAdapter(LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
            this.sink = sink;
            this.leftTupleMemoryEnabled = leftTupleMemoryEnabled;
        }

        public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
            LeftTuple tuple = new LeftTuple(factHandle, this.sink, this.leftTupleMemoryEnabled);
            this.sink.assertLeftTuple(tuple, context, workingMemory);
        }

        public void retractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
            throw new UnsupportedOperationException("ObjectSinkAdapter onlys supports assertObject method calls");
        }

        public int getId() {
            return 0;
        }

        public RuleBasePartitionId getPartitionId() {
            return this.sink.getPartitionId();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }
    }
}

