/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.provider;

import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Validator;
import org.opensaml.common.xml.SAMLSchemaBuilder;
import org.opensaml.saml2.metadata.provider.FilterException;
import org.opensaml.saml2.metadata.provider.MetadataFilter;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class SchemaValidationFilter
implements MetadataFilter {
    private final Logger log = LoggerFactory.getLogger(SchemaValidationFilter.class);

    public SchemaValidationFilter(String[] extensionSchemas) {
        if (extensionSchemas != null) {
            for (String extension : extensionSchemas) {
                if ((extension = DatatypeHelper.safeTrimOrNullString((String)extension)) == null) continue;
                SAMLSchemaBuilder.addExtensionSchema(extension);
            }
        }
    }

    public void doFilter(XMLObject metadata) throws FilterException {
        Validator schemaValidator = null;
        try {
            schemaValidator = SAMLSchemaBuilder.getSAML11Schema().newValidator();
        }
        catch (SAXException e) {
            this.log.error("Unable to build metadata validation schema", (Throwable)e);
            throw new FilterException("Unable to build metadata validation schema", e);
        }
        try {
            schemaValidator.validate(new DOMSource(metadata.getDOM()));
        }
        catch (Exception e) {
            this.log.error("Incoming metadata was not schema valid.", (Throwable)e);
            throw new FilterException("Incoming metadata was not schema valid.", e);
        }
    }
}

