/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api;

import java.io.File;
import java.net.URL;
import javax.net.ssl.SSLSocketFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.security.tls.TlsConfiguration;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class TlsConfigurationTestCase
extends AbstractMuleTestCase {
    @Test
    public void testEmptyConfiguration() throws Exception {
        TlsConfiguration configuration = new TlsConfiguration(".keystore");
        try {
            configuration.initialise(false, "javax.net");
            Assert.fail((String)"no key password");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((String)"expected", (Object)e);
        }
        configuration.setKeyPassword("mulepassword");
        try {
            configuration.initialise(false, "javax.net");
            Assert.fail((String)"no store password");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((String)"expected", (Object)e);
        }
        configuration.setKeyStorePassword("mulepassword");
        configuration.setKeyStore("");
        try {
            configuration.initialise(false, "javax.net");
            Assert.fail((String)"no keystore");
        }
        catch (Exception e) {
            Assert.assertNotNull((String)"expected", (Object)e);
        }
    }

    @Test
    public void testSimpleSocket() throws Exception {
        TlsConfiguration configuration = new TlsConfiguration(".keystore");
        configuration.setKeyPassword("mulepassword");
        configuration.setKeyStorePassword("mulepassword");
        configuration.setKeyStore("clientKeystore");
        configuration.initialise(false, "javax.net");
        SSLSocketFactory socketFactory = configuration.getSocketFactory();
        Assert.assertTrue((String)"socket is useless", (socketFactory.getSupportedCipherSuites().length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testExceptionOnInvalidKeyAlias() throws Exception {
        URL keystoreUrl = this.getClass().getClassLoader().getResource("serverKeystore");
        File keystoreFile = new File(keystoreUrl.toURI());
        TlsConfiguration config = new TlsConfiguration(keystoreFile.getAbsolutePath());
        config.setKeyStorePassword("mulepassword");
        config.setKeyPassword("mulepassword");
        config.setKeyAlias("this_key_does_not_exist_in_the_keystore");
        try {
            config.initialise(false, "javax.net");
        }
        catch (CreateException ce) {
            Assert.assertTrue((boolean)(ce.getCause() instanceof IllegalStateException));
        }
    }
}

