/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context;

import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.registry.ServiceType;
import org.mule.config.ExceptionHelper;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DefaultMuleContextTestCase
extends AbstractMuleTestCase {
    public static final String INITIAL_VALUE = "500";
    public static final String VALUE_AFTER_REDEPLOY = "222";
    public static final String TEST_PROTOCOL = "test2";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClearExceptionHelperCacheForAppWhenDispose() throws Exception {
        MuleContext ctx = new DefaultMuleContextFactory().createMuleContext();
        String value = ExceptionHelper.getErrorMapping((String)TEST_PROTOCOL, IllegalArgumentException.class, (MuleContext)ctx);
        Assert.assertThat((Object)value, (Matcher)Is.is((Object)INITIAL_VALUE));
        ctx.dispose();
        URL url = DefaultMuleContextTestCase.class.getClassLoader().getResource("META-INF/services/" + ServiceType.EXCEPTION.getPath() + "/" + TEST_PROTOCOL + "-exception-mappings.properties");
        File exceptionMappingFile = new File(url.getFile());
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(exceptionMappingFile);
            fileWriter.append("\njava.lang.IllegalArgumentException=222");
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
        ctx = new DefaultMuleContextFactory().createMuleContext();
        ctx.setExecutionClassLoader(this.getClass().getClassLoader());
        value = ExceptionHelper.getErrorMapping((String)TEST_PROTOCOL, IllegalArgumentException.class, (MuleContext)ctx);
        Assert.assertThat((Object)value, (Matcher)Is.is((Object)VALUE_AFTER_REDEPLOY));
    }
}

