/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.transport.PropertyScope;
import org.mule.expression.VariableExpressionEnricher;
import org.mule.expression.VariableExpressionEvaluator;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class VariableEnricherEvaluatorTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testEnrichEvaluate() throws Exception {
        VariableExpressionEvaluator eval = new VariableExpressionEvaluator();
        VariableExpressionEnricher enricher = new VariableExpressionEnricher();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        enricher.enrich("foo", (MuleMessage)message, (Object)"fooValue");
        Object result = eval.evaluate("foo", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"fooValue", (Object)result);
        try {
            eval.evaluate("fool", (MuleMessage)message);
            Assert.fail((String)"required value");
        }
        catch (Exception e) {
            // empty catch block
        }
        result = message.getProperty("foo", PropertyScope.INVOCATION);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"fooValue", (Object)result);
    }

    @Test
    public void testEnrichEvaluateWithManager() throws Exception {
        ExpressionManager expressionManager = muleContext.getExpressionManager();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        expressionManager.enrich("#[variable:foo]", (MuleMessage)message, (Object)"fooValue");
        Object result = expressionManager.evaluate("#[variable:foo]", (MuleMessage)message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"fooValue", (Object)result);
        try {
            expressionManager.evaluate("#[variable:fool]", (MuleMessage)message);
            Assert.fail((String)"required value");
        }
        catch (Exception e) {
            // empty catch block
        }
        result = message.getProperty("foo", PropertyScope.INVOCATION);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"fooValue", (Object)result);
    }
}

