/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.MatchableMessageProcessor;
import org.mule.api.routing.OutboundRouterCatchAllStrategy;
import org.mule.api.routing.RoutingException;
import org.mule.api.routing.filter.Filter;
import org.mule.routing.AbstractCatchAllStrategy;
import org.mule.routing.LoggingCatchAllStrategy;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.outbound.DefaultOutboundRouterCollection;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.routing.outbound.RouterTestUtils;
import org.mule.tck.MuleEventCheckAnswer;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class OutboundMessageRouterTestCase
extends AbstractMuleContextTestCase {
    public OutboundMessageRouterTestCase() {
        this.setStartContext(true);
    }

    @Test
    public void testOutboundMessageRouter() throws Exception {
        DefaultOutboundRouterCollection messageRouter = this.createObject(DefaultOutboundRouterCollection.class);
        messageRouter.setCatchAllStrategy((OutboundRouterCatchAllStrategy)new LoggingCatchAllStrategy());
        Assert.assertNotNull((Object)messageRouter.getCatchAllStrategy());
        OutboundEndpoint endpoint1 = OutboundMessageRouterTestCase.getTestOutboundEndpoint("Test1Provider", "test://Test1Provider?exchangePattern=one-way");
        Assert.assertNotNull((Object)endpoint1);
        OutboundEndpoint mockendpoint1 = RouterTestUtils.createMockEndpoint(endpoint1);
        OutboundEndpoint endpoint2 = OutboundMessageRouterTestCase.getTestOutboundEndpoint("Test2Provider");
        Assert.assertNotNull((Object)endpoint2);
        OutboundEndpoint mockendpoint2 = RouterTestUtils.createMockEndpoint(endpoint2);
        FilteringOutboundRouter router1 = new FilteringOutboundRouter();
        PayloadTypeFilter filter = new PayloadTypeFilter(String.class);
        router1.setFilter((Filter)filter);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(mockendpoint1);
        router1.setRoutes(endpoints);
        FilteringOutboundRouter router2 = new FilteringOutboundRouter();
        PayloadTypeFilter filter2 = new PayloadTypeFilter();
        filter2.setExpectedType(Exception.class);
        router2.setFilter((Filter)filter2);
        endpoints = new ArrayList();
        endpoints.add(mockendpoint2);
        router2.setRoutes(endpoints);
        messageRouter.addRoute((MatchableMessageProcessor)router1);
        Assert.assertEquals((long)1L, (long)messageRouter.getRoutes().size());
        messageRouter.removeRoute((MatchableMessageProcessor)router1);
        Assert.assertEquals((long)0L, (long)messageRouter.getRoutes().size());
        ArrayList<FilteringOutboundRouter> list = new ArrayList<FilteringOutboundRouter>();
        list.add(router1);
        list.add(router2);
        messageRouter.setMessageProcessors(list);
        MuleSession session = (MuleSession)Mockito.mock(MuleSession.class);
        MuleEvent event = OutboundMessageRouterTestCase.getTestEvent((Object)"test event", session);
        Mockito.when((Object)mockendpoint1.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer());
        messageRouter.process(event);
        event = OutboundMessageRouterTestCase.getTestEvent((Object)new IllegalArgumentException(), session);
        Mockito.when((Object)mockendpoint2.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer());
        messageRouter.process(event);
        FilteringOutboundRouter router3 = new FilteringOutboundRouter();
        router3.setFilter((Filter)new PayloadTypeFilter(Object.class));
        endpoints = new ArrayList();
        endpoints.add(mockendpoint2);
        router3.setRoutes(endpoints);
        messageRouter.addRoute((MatchableMessageProcessor)router3);
        event = OutboundMessageRouterTestCase.getTestEvent((Object)"testing multiple routing", session);
        messageRouter.setMatchAll(true);
        messageRouter.process(event);
    }

    @Test
    public void testRouterWithCatchAll() throws Exception {
        final int[] count1 = new int[]{0};
        final int[] count2 = new int[]{0};
        final int[] catchAllCount = new int[]{0};
        DefaultOutboundRouterCollection messageRouter = new DefaultOutboundRouterCollection();
        FilteringOutboundRouter filterRouter1 = new FilteringOutboundRouter(){

            public MuleEvent route(MuleEvent event) throws RoutingException {
                count1[0] = count1[0] + 1;
                return event;
            }
        };
        FilteringOutboundRouter filterRouter2 = new FilteringOutboundRouter(){

            public MuleEvent route(MuleEvent event) throws RoutingException {
                count2[0] = count2[0] + 1;
                return event;
            }
        };
        filterRouter1.setFilter((Filter)new PayloadTypeFilter(Exception.class));
        filterRouter2.setFilter((Filter)new PayloadTypeFilter(StringBuffer.class));
        messageRouter.addRoute((MatchableMessageProcessor)filterRouter1);
        messageRouter.addRoute((MatchableMessageProcessor)filterRouter2);
        AbstractCatchAllStrategy strategy = new AbstractCatchAllStrategy(){

            public MuleEvent doCatchMessage(MuleEvent event) throws RoutingException {
                catchAllCount[0] = catchAllCount[0] + 1;
                return null;
            }
        };
        messageRouter.setCatchAllStrategy((OutboundRouterCatchAllStrategy)strategy);
        MuleEvent event = OutboundMessageRouterTestCase.getTestEvent("hello");
        messageRouter.process(event);
        Assert.assertEquals((long)1L, (long)catchAllCount[0]);
        Assert.assertEquals((long)0L, (long)count1[0]);
        Assert.assertEquals((long)0L, (long)count2[0]);
        event = OutboundMessageRouterTestCase.getTestEvent(new StringBuffer());
        messageRouter.process(event);
        Assert.assertEquals((long)1L, (long)catchAllCount[0]);
        Assert.assertEquals((long)0L, (long)count1[0]);
        Assert.assertEquals((long)1L, (long)count2[0]);
        event = OutboundMessageRouterTestCase.getTestEvent(new Exception());
        messageRouter.process(event);
        Assert.assertEquals((long)1L, (long)catchAllCount[0]);
        Assert.assertEquals((long)1L, (long)count1[0]);
        Assert.assertEquals((long)1L, (long)count2[0]);
    }

    @Test
    public void testCorrelation() throws Exception {
        FilteringOutboundRouter filterRouter = new FilteringOutboundRouter();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new StringBuffer(), muleContext);
        OutboundEndpoint endpoint = OutboundMessageRouterTestCase.getTestOutboundEndpoint("test");
        filterRouter.setMessageProperties((FlowConstruct)OutboundMessageRouterTestCase.getTestService(), (MuleMessage)message, (MessageProcessor)endpoint);
        Assert.assertNotNull((Object)message.getCorrelationId());
    }
}

