/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.resource.spi.work.WorkListener;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.io.LineIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MessageExchangePattern;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleSession;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextBuilder;
import org.mule.api.context.notification.MuleContextNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.api.routing.filter.Filter;
import org.mule.api.service.Service;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.builders.DefaultsConfigurationBuilder;
import org.mule.config.builders.SimpleConfigurationBuilder;
import org.mule.context.DefaultMuleContextBuilder;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.context.notification.MuleContextNotification;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.PortUtils;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.TestCaseWatchdog;
import org.mule.tck.TestCaseWatchdogTimeoutHandler;
import org.mule.tck.TestingWorkListener;
import org.mule.tck.TriggerableMessageSource;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.util.ClassUtils;
import org.mule.util.FileUtils;
import org.mule.util.IOUtils;
import org.mule.util.MuleUrlStreamHandlerFactory;
import org.mule.util.StringMessageUtils;
import org.mule.util.StringUtils;
import org.mule.util.SystemUtils;
import org.mule.util.concurrent.Latch;

@Deprecated
public abstract class AbstractMuleTestCase
extends TestCase
implements TestCaseWatchdogTimeoutHandler {
    public static final String[] IGNORED_DOT_MULE_DIRS = new String[]{"transaction-log"};
    public static final String PROPERTY_MULE_TEST_TIMEOUT = "mule.test.timeoutSecs";
    public static final int DEFAULT_MULE_TEST_TIMEOUT_SECS = 60;
    public static final String CLASSNAME_ANNOTATIONS_CONFIG_BUILDER = "org.mule.config.AnnotationsConfigurationBuilder";
    protected static MuleContext muleContext;
    private static final boolean verbose;
    private static final Map<String, TestInfo> testInfos;
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    private boolean startContext = false;
    private boolean offline = "true".equalsIgnoreCase(System.getProperty("org.mule.offline"));
    private TestCaseWatchdog watchdog;
    protected int numPorts = 0;
    public List<Integer> ports = null;
    public static final String TEST_MESSAGE = "Test Message";
    public static final long LOCK_TIMEOUT = 30000L;
    public static final int RECEIVE_TIMEOUT = 5000;
    protected Latch callbackCalled;
    protected int testTimeoutSecs = 60;
    private boolean failOnTimeout = true;
    private volatile Thread currentTestRunningThread;

    public AbstractMuleTestCase() {
        TestInfo info = this.getTestInfo();
        if (info == null) {
            info = this.createTestInfo();
            testInfos.put(this.getClass().getName(), info);
        }
        this.registerTestMethod();
        this.initTestTimeoutSecs();
    }

    protected void registerTestMethod() {
        if (this.getName() != null) {
            this.getTestInfo().incTestCount(this.getName());
        }
    }

    protected void initTestTimeoutSecs() {
        String timeoutString = System.getProperty(PROPERTY_MULE_TEST_TIMEOUT, null);
        if (timeoutString == null) {
            String variableName = PROPERTY_MULE_TEST_TIMEOUT.toUpperCase().replace(".", "_");
            timeoutString = System.getenv(variableName);
        }
        if (timeoutString != null) {
            try {
                this.testTimeoutSecs = Integer.parseInt(timeoutString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void setName(String name) {
        super.setName(name);
        this.registerTestMethod();
    }

    protected TestInfo createTestInfo() {
        return new TestInfo(this);
    }

    protected TestInfo getTestInfo() {
        return testInfos.get(this.getClass().getName());
    }

    private void clearInfo() {
        testInfos.remove(this.getClass().getName());
    }

    public void run(TestResult result) {
        if (this.isExcluded()) {
            if (verbose) {
                this.logger.info((Object)(this.getClass().getName() + " excluded"));
            }
            return;
        }
        if (this.isDisabledInThisEnvironment()) {
            if (verbose) {
                this.logger.info((Object)(this.getClass().getName() + " disabled"));
            }
            return;
        }
        super.run(result);
    }

    public void runBare() throws Throwable {
        if (this.isDisabledInThisEnvironment(super.getName())) {
            this.logger.warn((Object)(this.getClass().getName() + "." + super.getName() + " disabled in this environment"));
            return;
        }
        super.runBare();
    }

    protected boolean isDisabledInThisEnvironment() {
        return false;
    }

    protected boolean isExcluded() {
        return this.getTestInfo().isExcluded();
    }

    protected boolean isDisabledInThisEnvironment(String testMethodName) {
        return false;
    }

    public boolean isOffline(String method) {
        if (this.offline) {
            this.logger.warn((Object)StringMessageUtils.getBoilerPlate((String)("Working offline cannot run test: " + method), (char)'=', (int)80));
        }
        return this.offline;
    }

    protected boolean isDisposeManagerPerSuite() {
        return this.getTestInfo().isDisposeManagerPerSuite();
    }

    protected void setDisposeManagerPerSuite(boolean val) {
        this.getTestInfo().setDisposeManagerPerSuite(val);
    }

    public int getTestTimeoutSecs() {
        return this.testTimeoutSecs;
    }

    protected TestCaseWatchdog createWatchdog() {
        return new TestCaseWatchdog(this.testTimeoutSecs, TimeUnit.SECONDS, this);
    }

    @Override
    public void handleTimeout(long timeout, TimeUnit unit) {
        String msg = "Timeout of " + unit.toMillis(timeout) + "ms exceeded (modify via -Dmule.test.timeoutSecs=XX)";
        if (this.failOnTimeout) {
            this.logger.fatal((Object)(msg + " - Attempting to interrupt thread for test " + this.getName()));
            if (this.currentTestRunningThread != null) {
                this.currentTestRunningThread.interrupt();
            }
            this.giveTheTestSomeTimeToCleanUpAndThenKillIt("Interrupting didn't work. Killing the VM!. Test " + this.getName() + " did not finish correctly.");
        } else {
            this.logger.warn((Object)msg);
        }
    }

    protected void giveTheTestSomeTimeToCleanUpAndThenKillIt(String messageIfNeedToKill) {
        try {
            Thread.sleep(5000L);
            this.logger.fatal((Object)messageIfNeedToKill);
            Runtime.getRuntime().halt(1);
        }
        catch (InterruptedException e) {
            this.logger.info((Object)"Test thread has been interrupted, probably bt the call to watchdog.cancel() in teardown method.", (Throwable)e);
        }
    }

    protected final void setUp() throws Exception {
        this.watchdog = this.createWatchdog();
        this.watchdog.start();
        if (this.numPorts > 0) {
            this.ports = PortUtils.findFreePorts(this.numPorts);
            this.setPortProperties();
        }
        this.currentTestRunningThread = Thread.currentThread();
        this.printTestHeader();
        try {
            if (this.getTestInfo().getRunCount() == 0) {
                if (this.getTestInfo().isDisposeManagerPerSuite()) {
                    this.disposeManager();
                }
                this.suitePreSetUp();
            }
            if (!this.getTestInfo().isDisposeManagerPerSuite()) {
                this.disposeManager();
            }
            muleContext = this.createMuleContext();
            final AtomicReference<Latch> contextStartedLatch = new AtomicReference<Latch>();
            if (this.isStartContext() && null != muleContext && !muleContext.isStarted()) {
                contextStartedLatch.set(new Latch());
                muleContext.registerListener((ServerNotificationListener)new MuleContextNotificationListener<MuleContextNotification>(){

                    public void onNotification(MuleContextNotification notification) {
                        if (notification.getAction() == 104) {
                            ((Latch)contextStartedLatch.get()).countDown();
                        }
                    }
                });
                muleContext.start();
            }
            if (contextStartedLatch.get() != null) {
                ((Latch)contextStartedLatch.get()).await(20L, TimeUnit.SECONDS);
            }
            this.doSetUp();
        }
        catch (Exception e) {
            this.getTestInfo().incRunCount();
            throw e;
        }
    }

    protected void printTestHeader() {
        if (verbose) {
            System.out.println(StringMessageUtils.getBoilerPlate((String)this.getTestHeader(), (char)'=', (int)80));
        }
    }

    protected String getTestHeader() {
        return "Testing: " + this.getName();
    }

    protected MuleContext createMuleContext() throws Exception {
        MuleContext context;
        if (this.getTestInfo().isDisposeManagerPerSuite() && muleContext != null) {
            context = muleContext;
        } else {
            DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
            ArrayList<ConfigurationBuilder> builders = new ArrayList<ConfigurationBuilder>();
            builders.add((ConfigurationBuilder)new SimpleConfigurationBuilder((Map)this.getStartUpProperties()));
            if (ClassUtils.isClassOnPath((String)CLASSNAME_ANNOTATIONS_CONFIG_BUILDER, this.getClass())) {
                builders.add((ConfigurationBuilder)ClassUtils.instanciateClass((String)CLASSNAME_ANNOTATIONS_CONFIG_BUILDER, (Object[])ClassUtils.NO_ARGS, this.getClass()));
            }
            builders.add(this.getBuilder());
            this.addBuilders(builders);
            DefaultMuleContextBuilder contextBuilder = new DefaultMuleContextBuilder();
            this.configureMuleContext((MuleContextBuilder)contextBuilder);
            context = muleContextFactory.createMuleContext(builders, (MuleContextBuilder)contextBuilder);
            if (!this.isGracefulShutdown()) {
                ((DefaultMuleConfiguration)context.getConfiguration()).setShutdownTimeout(0);
            }
        }
        return context;
    }

    protected void addBuilders(List<ConfigurationBuilder> builders) {
    }

    protected void configureMuleContext(MuleContextBuilder contextBuilder) {
        contextBuilder.setWorkListener((WorkListener)new TestingWorkListener());
    }

    protected ConfigurationBuilder getBuilder() throws Exception {
        return new DefaultsConfigurationBuilder();
    }

    protected String getConfigurationResources() {
        return "";
    }

    protected Properties getStartUpProperties() {
        return null;
    }

    protected void suitePreSetUp() throws Exception {
    }

    protected void suitePostTearDown() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void tearDown() throws Exception {
        try {
            this.doTearDown();
            if (!this.getTestInfo().isDisposeManagerPerSuite()) {
                this.disposeManager();
            }
        }
        finally {
            block15: {
                try {
                    this.getTestInfo().incRunCount();
                    if (this.getTestInfo().getRunCount() != this.getTestInfo().getTestCount()) break block15;
                    try {
                        this.suitePostTearDown();
                    }
                    finally {
                        this.clearInfo();
                        this.disposeManager();
                    }
                }
                finally {
                    this.watchdog.cancel();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeManager() {
        try {
            if (muleContext != null && !muleContext.isDisposed() && !muleContext.isDisposing()) {
                muleContext.dispose();
                String workingDir = muleContext.getConfiguration().getWorkingDirectory();
                FileUtils.deleteTree((File)FileUtils.newFile((String)workingDir), (String[])IGNORED_DOT_MULE_DIRS);
            }
            FileUtils.deleteTree((File)FileUtils.newFile((String)"./ActiveMQ"));
        }
        finally {
            muleContext = null;
        }
    }

    protected void doSetUp() throws Exception {
    }

    protected void doTearDown() throws Exception {
        RequestContext.clear();
    }

    public static InboundEndpoint getTestInboundEndpoint(String name) throws Exception {
        return MuleTestUtils.getTestInboundEndpoint(name, muleContext);
    }

    public static OutboundEndpoint getTestOutboundEndpoint(String name) throws Exception {
        return MuleTestUtils.getTestOutboundEndpoint(name, muleContext);
    }

    public static InboundEndpoint getTestInboundEndpoint(MessageExchangePattern mep) throws Exception {
        return MuleTestUtils.getTestInboundEndpoint(mep, muleContext);
    }

    public static InboundEndpoint getTestTransactedInboundEndpoint(MessageExchangePattern mep) throws Exception {
        return MuleTestUtils.getTestTransactedInboundEndpoint(mep, muleContext);
    }

    public static InboundEndpoint getTestInboundEndpoint(String name, String uri) throws Exception {
        return MuleTestUtils.getTestInboundEndpoint(name, muleContext, uri, null, null, null, null);
    }

    public static OutboundEndpoint getTestOutboundEndpoint(String name, String uri) throws Exception {
        return MuleTestUtils.getTestOutboundEndpoint(name, muleContext, uri, null, null, null);
    }

    public static InboundEndpoint getTestInboundEndpoint(String name, List<Transformer> transformers) throws Exception {
        return MuleTestUtils.getTestInboundEndpoint(name, muleContext, null, transformers, null, null, null);
    }

    public static OutboundEndpoint getTestOutboundEndpoint(String name, List<Transformer> transformers) throws Exception {
        return MuleTestUtils.getTestOutboundEndpoint(name, muleContext, null, transformers, null, null);
    }

    public static InboundEndpoint getTestInboundEndpoint(String name, String uri, List<Transformer> transformers, Filter filter, Map<Object, Object> properties, Connector connector) throws Exception {
        return MuleTestUtils.getTestInboundEndpoint(name, muleContext, uri, transformers, filter, properties, connector);
    }

    public static OutboundEndpoint getTestOutboundEndpoint(String name, String uri, List<Transformer> transformers, Filter filter, Map<Object, Object> properties) throws Exception {
        return MuleTestUtils.getTestOutboundEndpoint(name, muleContext, uri, transformers, filter, properties);
    }

    public static InboundEndpoint getTestInboundEndpoint(String name, String uri, List<Transformer> transformers, Filter filter, Map<Object, Object> properties) throws Exception {
        return MuleTestUtils.getTestInboundEndpoint(name, muleContext, uri, transformers, filter, properties);
    }

    public static OutboundEndpoint getTestOutboundEndpoint(String name, String uri, List<Transformer> transformers, Filter filter, Map<Object, Object> properties, Connector connector) throws Exception {
        return MuleTestUtils.getTestOutboundEndpoint(name, muleContext, uri, transformers, filter, properties, connector);
    }

    public static MuleEvent getTestEvent(Object data, Service service) throws Exception {
        return MuleTestUtils.getTestEvent(data, (FlowConstruct)service, MessageExchangePattern.REQUEST_RESPONSE, muleContext);
    }

    public static MuleEvent getTestEvent(Object data, Service service, MessageExchangePattern mep) throws Exception {
        return MuleTestUtils.getTestEvent(data, (FlowConstruct)service, mep, muleContext);
    }

    public static MuleEvent getTestEvent(Object data) throws Exception {
        return MuleTestUtils.getTestEvent(data, MessageExchangePattern.REQUEST_RESPONSE, muleContext);
    }

    public static MuleEvent getTestEventUsingFlow(Object data) throws Exception {
        return MuleTestUtils.getTestEventUsingFlow(data, MessageExchangePattern.REQUEST_RESPONSE, muleContext);
    }

    public static MuleEvent getTestEvent(Object data, MessageExchangePattern mep) throws Exception {
        return MuleTestUtils.getTestEvent(data, mep, muleContext);
    }

    public static MuleEvent getTestEvent(Object data, MuleSession session) throws Exception {
        return MuleTestUtils.getTestEvent(data, session, muleContext);
    }

    public static MuleEventContext getTestEventContext(Object data) throws Exception {
        return MuleTestUtils.getTestEventContext(data, MessageExchangePattern.REQUEST_RESPONSE, muleContext);
    }

    public static MuleEventContext getTestEventContext(Object data, MessageExchangePattern mep) throws Exception {
        return MuleTestUtils.getTestEventContext(data, mep, muleContext);
    }

    public static Transformer getTestTransformer() throws Exception {
        return MuleTestUtils.getTestTransformer();
    }

    public static MuleEvent getTestEvent(Object data, InboundEndpoint endpoint) throws Exception {
        return MuleTestUtils.getTestEvent(data, endpoint, muleContext);
    }

    public static MuleEvent getTestEvent(Object data, Service service, InboundEndpoint endpoint) throws Exception {
        return MuleTestUtils.getTestEvent(data, (FlowConstruct)service, endpoint, muleContext);
    }

    public static MuleSession getTestSession(Service service, MuleContext context) {
        return MuleTestUtils.getTestSession((FlowConstruct)service, context);
    }

    public static TestConnector getTestConnector() throws Exception {
        return MuleTestUtils.getTestConnector(muleContext);
    }

    public static Service getTestService() throws Exception {
        return MuleTestUtils.getTestService(muleContext);
    }

    public static Service getTestService(String name, Class<?> clazz) throws Exception {
        return MuleTestUtils.getTestService(name, clazz, muleContext);
    }

    public static Service getTestService(String name, Class<?> clazz, Map<?, ?> props) throws Exception {
        return MuleTestUtils.getTestService(name, clazz, props, muleContext);
    }

    protected boolean isStartContext() {
        return this.startContext;
    }

    protected void setStartContext(boolean startContext) {
        this.startContext = startContext;
    }

    public void setFailOnTimeout(boolean failOnTimeout) {
        this.failOnTimeout = failOnTimeout;
    }

    protected boolean isGracefulShutdown() {
        return false;
    }

    protected <T> T createObject(Class<T> clazz) throws Exception {
        return this.createObject(clazz, ClassUtils.NO_ARGS);
    }

    protected <T> T createObject(Class<T> clazz, Object ... args) throws Exception {
        if (args == null) {
            args = ClassUtils.NO_ARGS;
        }
        Object o = ClassUtils.instanciateClass(clazz, (Object[])args);
        muleContext.getRegistry().registerObject(String.valueOf(o.hashCode()), o);
        return (T)o;
    }

    protected void initialiseObject(Object o) throws RegistrationException {
        muleContext.getRegistry().registerObject(String.valueOf(o.hashCode()), o);
    }

    public SensingNullMessageProcessor getSensingNullMessageProcessor() {
        return new SensingNullMessageProcessor();
    }

    public TriggerableMessageSource getTriggerableMessageSource(MessageProcessor listener) {
        return new TriggerableMessageSource(listener);
    }

    public TriggerableMessageSource getTriggerableMessageSource() {
        return new TriggerableMessageSource();
    }

    private void setPortProperties() {
        for (int i = 0; i < this.ports.size(); ++i) {
            System.setProperty("port" + (i + 1), String.valueOf(this.ports.get(i)));
        }
    }

    public List<Integer> getPorts() {
        return this.ports;
    }

    static {
        testInfos = Collections.synchronizedMap(new HashMap());
        String muleOpts = SystemUtils.getenv((String)"MULE_TEST_OPTS");
        if (StringUtils.isNotBlank((String)muleOpts)) {
            Map parsedOpts = SystemUtils.parsePropertyDefinitions((String)muleOpts);
            String optVerbose = (String)parsedOpts.get("mule.verbose");
            verbose = Boolean.valueOf(optVerbose);
        } else {
            verbose = true;
        }
        MuleUrlStreamHandlerFactory.installUrlStreamHandlerFactory();
    }

    public static class TestInfo {
        private final String name;
        private boolean disposeManagerPerSuite;
        private boolean excluded;
        private volatile int testCount;
        private volatile int runCount;
        private Set<String> registeredTestMethod;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TestInfo(TestCase test) {
            block5: {
                this.disposeManagerPerSuite = false;
                this.excluded = false;
                this.testCount = 0;
                this.runCount = 0;
                this.registeredTestMethod = new HashSet<String>();
                this.name = test.getClass().getName();
                try {
                    URL classUrl = ClassUtils.getClassPathRoot(test.getClass());
                    URLClassLoader tempClassLoader = new URLClassLoader(new URL[]{classUrl});
                    URL fileUrl = tempClassLoader.getResource("mule-test-exclusions.txt");
                    if (fileUrl == null) break block5;
                    InputStream in = null;
                    try {
                        in = fileUrl.openStream();
                        LineIterator lines = IOUtils.lineIterator((InputStream)in, (String)"UTF-8");
                        this.excluded = IteratorUtils.filteredIterator((Iterator)lines, (Predicate)new Predicate(){

                            public boolean evaluate(Object object) {
                                return StringUtils.equals((String)TestInfo.this.name, (String)StringUtils.trimToEmpty((String)((String)object)));
                            }
                        }).hasNext();
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)in);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public int getTestCount() {
            return this.testCount;
        }

        public synchronized void incTestCount(String testName) {
            if (!this.registeredTestMethod.contains(testName)) {
                ++this.testCount;
                this.registeredTestMethod.add(testName);
            }
        }

        public int getRunCount() {
            return this.runCount;
        }

        public void incRunCount() {
            ++this.runCount;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDisposeManagerPerSuite() {
            return this.disposeManagerPerSuite;
        }

        public void setDisposeManagerPerSuite(boolean disposeManagerPerSuite) {
            this.disposeManagerPerSuite = disposeManagerPerSuite;
        }

        public boolean isExcluded() {
            return this.excluded;
        }

        public synchronized String toString() {
            StringBuffer buf = new StringBuffer();
            return buf.append(this.name).append(", (").append(this.runCount).append(" / ").append(this.testCount).append(") tests run, disposePerSuite=").append(this.disposeManagerPerSuite).toString();
        }
    }
}

