/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.Serializable;
import org.apache.commons.lang.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.CaseInsensitiveHashMap;

@SmallTest
public class CaseInsensitiveHashMapTestCase
extends AbstractMuleTestCase {
    protected CaseInsensitiveHashMap createTestMap() {
        CaseInsensitiveHashMap map = new CaseInsensitiveHashMap();
        map.put((Object)"FOO", (Object)"BAR");
        map.put((Object)"DOO", (Object)3);
        return map;
    }

    @Test
    public void testMap() throws Exception {
        CaseInsensitiveHashMap map = this.createTestMap();
        this.doTestMap(map);
    }

    @Test
    public void testMapSerialization() throws Exception {
        CaseInsensitiveHashMap map = this.createTestMap();
        this.doTestMap(map);
        byte[] bytes = SerializationUtils.serialize((Serializable)map);
        CaseInsensitiveHashMap resultMap = (CaseInsensitiveHashMap)SerializationUtils.deserialize((byte[])bytes);
        this.doTestMap(resultMap);
    }

    public void doTestMap(CaseInsensitiveHashMap map) throws Exception {
        Assert.assertEquals((Object)"BAR", (Object)map.get((Object)"FOO"));
        Assert.assertEquals((Object)"BAR", (Object)map.get((Object)"foo"));
        Assert.assertEquals((Object)"BAR", (Object)map.get((Object)"Foo"));
        Assert.assertEquals((Object)3, (Object)map.get((Object)"DOO"));
        Assert.assertEquals((Object)3, (Object)map.get((Object)"doo"));
        Assert.assertEquals((Object)3, (Object)map.get((Object)"Doo"));
        Assert.assertEquals((long)2L, (long)map.size());
        for (Object o : map.keySet()) {
            Assert.assertTrue((o.equals("FOO") || o.equals("DOO") ? 1 : 0) != 0);
            Assert.assertFalse((o.equals("foo") || o.equals("doo") ? 1 : 0) != 0);
        }
    }
}

