/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.rm.BindingFaultFactory;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.policy.RM10PolicyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRMInterceptor<T extends Message>
extends AbstractPhaseInterceptor<T> {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractRMInterceptor.class);
    private RMManager manager;
    private Bus bus;

    protected AbstractRMInterceptor(String phase) {
        super(phase);
    }

    protected AbstractRMInterceptor() {
        this("pre-logical");
    }

    public RMManager getManager() {
        if (null == this.manager) {
            return (RMManager)this.bus.getExtension(RMManager.class);
        }
        return this.manager;
    }

    public void setManager(RMManager m) {
        this.manager = m;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public void handleMessage(Message msg) throws Fault {
        try {
            this.handle(msg);
        }
        catch (SequenceFault sf) {
            Endpoint e = (Endpoint)msg.getExchange().get(Endpoint.class);
            Binding b = null;
            if (null != e) {
                b = e.getBinding();
            }
            if (null != b) {
                RMManager m = this.getManager();
                LOG.fine("Manager: " + m);
                BindingFaultFactory bff = m.getBindingFaultFactory(b);
                Fault f = bff.createFault(sf, msg);
                LogUtils.log((Logger)LOG, (Level)Level.SEVERE, (String)"SEQ_FAULT_MSG", (Object)bff.toString(f));
                throw f;
            }
            throw new Fault((Throwable)sf);
        }
        catch (RMException ex) {
            throw new Fault((Throwable)((Object)ex));
        }
    }

    void assertReliability(Message message) {
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        Collection<AssertionInfo> ais = RM10PolicyUtils.collectRMAssertions(aim);
        for (AssertionInfo ai : ais) {
            ai.setAsserted(true);
        }
    }

    protected abstract void handle(Message var1) throws SequenceFault, RMException;
}

