/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.builder.jaxb.JaxbAssertion;
import org.apache.cxf.ws.rm.RM10Constants;
import org.apache.cxf.ws.rm.RM11Constants;
import org.apache.cxf.ws.rmp.v200502.RMAssertion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RM10PolicyUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(RM10PolicyUtils.class);

    private RM10PolicyUtils() {
    }

    public static Collection<AssertionInfo> collectRMAssertions(AssertionInfoMap aim) {
        ArrayList<AssertionInfo> mergedAsserts = new ArrayList<AssertionInfo>();
        if (aim != null) {
            Collection ais = (Collection)aim.get((Object)RM10Constants.WSRMP_RMASSERTION_QNAME);
            if (ais != null) {
                mergedAsserts.addAll(ais);
            }
            if ((ais = (Collection)aim.get((Object)RM11Constants.WSRMP_RMASSERTION_QNAME)) != null) {
                mergedAsserts.addAll(ais);
            }
        }
        return mergedAsserts;
    }

    public static RMAssertion getRMAssertion(RMAssertion defaultValue, Message message) {
        RMAssertion compatible = defaultValue;
        Collection<AssertionInfo> ais = RM10PolicyUtils.collectRMAssertions((AssertionInfoMap)message.get(AssertionInfoMap.class));
        for (AssertionInfo ai : ais) {
            if (ai.getAssertion() instanceof JaxbAssertion && ((JaxbAssertion)ai.getAssertion()).getData() instanceof RMAssertion) {
                JaxbAssertion<RMAssertion> ja = RM10PolicyUtils.getAssertion(ai);
                RMAssertion rma = (RMAssertion)ja.getData();
                compatible = null == defaultValue ? rma : RM10PolicyUtils.intersect(compatible, rma);
                continue;
            }
            LOG.warning("Ignoring unexpected assertion class: " + ai.getAssertion());
        }
        return compatible;
    }

    public static RMAssertion intersect(RMAssertion a, RMAssertion b) {
        if (RM10PolicyUtils.equals(a, b)) {
            return a;
        }
        RMAssertion compatible = new RMAssertion();
        Long aval = null;
        if (null != a.getInactivityTimeout()) {
            aval = a.getInactivityTimeout().getMilliseconds();
        }
        Long bval = null;
        if (null != b.getInactivityTimeout()) {
            bval = b.getInactivityTimeout().getMilliseconds();
        }
        if (null != aval || null != bval) {
            RMAssertion.InactivityTimeout ia = new RMAssertion.InactivityTimeout();
            if (null != aval && null != bval) {
                ia.setMilliseconds(bval);
            } else {
                ia.setMilliseconds(aval != null ? aval : bval);
            }
            compatible.setInactivityTimeout(ia);
        }
        aval = null;
        if (null != a.getBaseRetransmissionInterval()) {
            aval = a.getBaseRetransmissionInterval().getMilliseconds();
        }
        bval = null;
        if (null != b.getBaseRetransmissionInterval()) {
            bval = b.getBaseRetransmissionInterval().getMilliseconds();
        }
        if (null != aval || null != bval) {
            RMAssertion.BaseRetransmissionInterval bri = new RMAssertion.BaseRetransmissionInterval();
            if (null != aval && null != bval) {
                bri.setMilliseconds(bval);
            } else {
                bri.setMilliseconds(aval != null ? aval : bval);
            }
            compatible.setBaseRetransmissionInterval(bri);
        }
        aval = null;
        if (null != a.getAcknowledgementInterval()) {
            aval = a.getAcknowledgementInterval().getMilliseconds();
        }
        bval = null;
        if (null != b.getAcknowledgementInterval()) {
            bval = b.getAcknowledgementInterval().getMilliseconds();
        }
        if (null != aval || null != bval) {
            RMAssertion.AcknowledgementInterval ai = new RMAssertion.AcknowledgementInterval();
            if (null != aval && null != bval) {
                ai.setMilliseconds(bval);
            } else {
                ai.setMilliseconds(aval != null ? aval : bval);
            }
            compatible.setAcknowledgementInterval(ai);
        }
        if (null != a.getExponentialBackoff() || null != b.getExponentialBackoff()) {
            compatible.setExponentialBackoff(new RMAssertion.ExponentialBackoff());
        }
        return compatible;
    }

    public static boolean equals(RMAssertion a, RMAssertion b) {
        if (a == b) {
            return true;
        }
        Long aval = null;
        if (null != a.getInactivityTimeout()) {
            aval = a.getInactivityTimeout().getMilliseconds();
        }
        Long bval = null;
        if (null != b.getInactivityTimeout()) {
            bval = b.getInactivityTimeout().getMilliseconds();
        }
        if (!RM10PolicyUtils.equals(aval, bval)) {
            return false;
        }
        aval = null;
        if (null != a.getBaseRetransmissionInterval()) {
            aval = a.getBaseRetransmissionInterval().getMilliseconds();
        }
        bval = null;
        if (null != b.getBaseRetransmissionInterval()) {
            bval = b.getBaseRetransmissionInterval().getMilliseconds();
        }
        if (!RM10PolicyUtils.equals(aval, bval)) {
            return false;
        }
        aval = null;
        if (null != a.getAcknowledgementInterval()) {
            aval = a.getAcknowledgementInterval().getMilliseconds();
        }
        bval = null;
        if (null != b.getAcknowledgementInterval()) {
            bval = b.getAcknowledgementInterval().getMilliseconds();
        }
        if (!RM10PolicyUtils.equals(aval, bval)) {
            return false;
        }
        return null == a.getExponentialBackoff() ? null == b.getExponentialBackoff() : null != b.getExponentialBackoff();
    }

    private static boolean equals(Long aval, Long bval) {
        if (null != aval) {
            if (null != bval) {
                return aval.equals(bval);
            }
            return false;
        }
        return null == bval;
    }

    private static JaxbAssertion<RMAssertion> getAssertion(AssertionInfo ai) {
        return (JaxbAssertion)ai.getAssertion();
    }
}

