/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.Tool;
import org.antlr.codegen.CodeGenerator;
import org.antlr.test.BaseTest;
import org.antlr.test.ErrorQueue;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarSemanticsMessage;
import org.antlr.tool.Message;

public class TestRewriteAST
extends BaseTest {
    protected boolean debug = false;

    public void testDelete() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc 34", this.debug);
        TestRewriteAST.assertEquals((String)"", (String)string2);
    }

    public void testSingleToken() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID -> ID;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc", this.debug);
        TestRewriteAST.assertEquals((String)"abc\n", (String)string2);
    }

    public void testSingleTokenToNewNode() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID -> ID[\"x\"];\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc", this.debug);
        TestRewriteAST.assertEquals((String)"x\n", (String)string2);
    }

    public void testSingleTokenToNewNodeRoot() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID -> ^(ID[\"x\"] INT);\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc", this.debug);
        TestRewriteAST.assertEquals((String)"(x INT)\n", (String)string2);
    }

    public void testSingleTokenToNewNode2() throws Exception {
        String string = "grammar TT;\noptions {output=AST;}\na : ID -> ID[ ];\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("TT.g", string, "TTParser", "TTLexer", "a", "abc", this.debug);
        TestRewriteAST.assertEquals((String)"ID\n", (String)string2);
    }

    public void testSingleCharLiteral() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : 'c' -> 'c';\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "c", this.debug);
        TestRewriteAST.assertEquals((String)"c\n", (String)string2);
    }

    public void testSingleStringLiteral() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : 'ick' -> 'ick';\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "ick", this.debug);
        TestRewriteAST.assertEquals((String)"ick\n", (String)string2);
    }

    public void testSingleRule() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : b -> b;\nb : ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc", this.debug);
        TestRewriteAST.assertEquals((String)"abc\n", (String)string2);
    }

    public void testReorderTokens() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> INT ID;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc 34", this.debug);
        TestRewriteAST.assertEquals((String)"34 abc\n", (String)string2);
    }

    public void testReorderTokenAndRule() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : b INT -> INT b;\nb : ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc 34", this.debug);
        TestRewriteAST.assertEquals((String)"34 abc\n", (String)string2);
    }

    public void testTokenTree() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> ^(INT ID);\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc 34", this.debug);
        TestRewriteAST.assertEquals((String)"(34 abc)\n", (String)string2);
    }

    public void testTokenTreeAfterOtherStuff() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : 'void' ID INT -> 'void' ^(INT ID);\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "void abc 34", this.debug);
        TestRewriteAST.assertEquals((String)"void (34 abc)\n", (String)string2);
    }

    public void testNestedTokenTreeWithOuterLoop() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {DUH;}\na : ID INT ID INT -> ^( DUH ID ^( DUH INT) )+ ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a 1 b 2", this.debug);
        TestRewriteAST.assertEquals((String)"(DUH a (DUH 1)) (DUH b (DUH 2))\n", (String)string2);
    }

    public void testOptionalSingleToken() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID -> ID? ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc", this.debug);
        TestRewriteAST.assertEquals((String)"abc\n", (String)string2);
    }

    public void testClosureSingleToken() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID ID -> ID* ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a b", this.debug);
        TestRewriteAST.assertEquals((String)"a b\n", (String)string2);
    }

    public void testPositiveClosureSingleToken() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID ID -> ID+ ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a b", this.debug);
        TestRewriteAST.assertEquals((String)"a b\n", (String)string2);
    }

    public void testOptionalSingleRule() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : b -> b?;\nb : ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc", this.debug);
        TestRewriteAST.assertEquals((String)"abc\n", (String)string2);
    }

    public void testClosureSingleRule() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : b b -> b*;\nb : ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a b", this.debug);
        TestRewriteAST.assertEquals((String)"a b\n", (String)string2);
    }

    public void testClosureOfLabel() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : x+=b x+=b -> $x*;\nb : ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a b", this.debug);
        TestRewriteAST.assertEquals((String)"a b\n", (String)string2);
    }

    public void testOptionalLabelNoListLabel() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : (x=ID)? -> $x?;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a", this.debug);
        TestRewriteAST.assertEquals((String)"a\n", (String)string2);
    }

    public void testPositiveClosureSingleRule() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : b b -> b+;\nb : ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a b", this.debug);
        TestRewriteAST.assertEquals((String)"a b\n", (String)string2);
    }

    public void testSinglePredicateT() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID -> {true}? ID -> ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc", this.debug);
        TestRewriteAST.assertEquals((String)"abc\n", (String)string2);
    }

    public void testSinglePredicateF() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID -> {false}? ID -> ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc", this.debug);
        TestRewriteAST.assertEquals((String)"", (String)string2);
    }

    public void testMultiplePredicate() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> {false}? ID\n           -> {true}? INT\n           -> \n  ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a 2", this.debug);
        TestRewriteAST.assertEquals((String)"2\n", (String)string2);
    }

    public void testMultiplePredicateTrees() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> {false}? ^(ID INT)\n           -> {true}? ^(INT ID)\n           -> ID\n  ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a 2", this.debug);
        TestRewriteAST.assertEquals((String)"(2 a)\n", (String)string2);
    }

    public void testSimpleTree() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : op INT -> ^(op INT);\nop : '+'|'-' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "-34", this.debug);
        TestRewriteAST.assertEquals((String)"(- 34)\n", (String)string2);
    }

    public void testSimpleTree2() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : op INT -> ^(INT op);\nop : '+'|'-' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "+ 34", this.debug);
        TestRewriteAST.assertEquals((String)"(34 +)\n", (String)string2);
    }

    public void testNestedTrees() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : 'var' (ID ':' type ';')+ -> ^('var' ^(':' ID type)+) ;\ntype : 'int' | 'float' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "var a:int; b:float;", this.debug);
        TestRewriteAST.assertEquals((String)"(var (: a int) (: b float))\n", (String)string2);
    }

    public void testImaginaryTokenCopy() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {VAR;}\na : ID (',' ID)*-> ^(VAR ID)+ ;\ntype : 'int' | 'float' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a,b,c", this.debug);
        TestRewriteAST.assertEquals((String)"(VAR a) (VAR b) (VAR c)\n", (String)string2);
    }

    public void testTokenUnreferencedOnLeftButDefined() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {VAR;}\na : b -> ID ;\nb : ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a", this.debug);
        TestRewriteAST.assertEquals((String)"ID\n", (String)string2);
    }

    public void testImaginaryTokenCopySetText() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {VAR;}\na : ID (',' ID)*-> ^(VAR[\"var\"] ID)+ ;\ntype : 'int' | 'float' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a,b,c", this.debug);
        TestRewriteAST.assertEquals((String)"(var a) (var b) (var c)\n", (String)string2);
    }

    public void testImaginaryTokenNoCopyFromToken() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : lc='{' ID+ '}' -> ^(BLOCK[$lc] ID+) ;\ntype : 'int' | 'float' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "{a b c}", this.debug);
        TestRewriteAST.assertEquals((String)"({ a b c)\n", (String)string2);
    }

    public void testImaginaryTokenNoCopyFromTokenSetText() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : lc='{' ID+ '}' -> ^(BLOCK[$lc,\"block\"] ID+) ;\ntype : 'int' | 'float' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "{a b c}", this.debug);
        TestRewriteAST.assertEquals((String)"(block a b c)\n", (String)string2);
    }

    public void testMixedRewriteAndAutoAST() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : b b^ ;\nb : ID INT -> INT ID\n  | INT\n  ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a 1 2", this.debug);
        TestRewriteAST.assertEquals((String)"(2 1 a)\n", (String)string2);
    }

    public void testSubruleWithRewrite() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : b b ;\nb : (ID INT -> INT ID | INT INT -> INT+ )\n  ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a 1 2 3", this.debug);
        TestRewriteAST.assertEquals((String)"1 a 2 3\n", (String)string2);
    }

    public void testSubruleWithRewrite2() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {TYPE;}\na : b b ;\nb : 'int'\n    ( ID -> ^(TYPE 'int' ID)\n    | ID '=' INT -> ^(TYPE 'int' ID INT)\n    )\n    ';'\n  ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "int a; int b=3;", this.debug);
        TestRewriteAST.assertEquals((String)"(TYPE int a) (TYPE int b 3)\n", (String)string2);
    }

    public void testNestedRewriteShutsOffAutoAST() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : b b ;\nb : ID ( ID (last=ID -> $last)+ ) ';'\n  | INT\n  ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a b c d; 42", this.debug);
        TestRewriteAST.assertEquals((String)"d 42\n", (String)string2);
    }

    public void testRewriteActions() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : atom -> ^({adaptor.create(INT,\"9\")} atom) ;\natom : INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "3", this.debug);
        TestRewriteAST.assertEquals((String)"(9 3)\n", (String)string2);
    }

    public void testRewriteActions2() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : atom -> {adaptor.create(INT,\"9\")} atom ;\natom : INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "3", this.debug);
        TestRewriteAST.assertEquals((String)"9 3\n", (String)string2);
    }

    public void testRefToOldValue() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : (atom -> atom) (op='+' r=atom -> ^($op $a $r) )* ;\natom : INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "3+4+5", this.debug);
        TestRewriteAST.assertEquals((String)"(+ (+ 3 4) 5)\n", (String)string2);
    }

    public void testCopySemanticsForRules() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : atom -> ^(atom atom) ;\natom : INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "3", this.debug);
        TestRewriteAST.assertEquals((String)"(3 3)\n", (String)string2);
    }

    public void testCopySemanticsForRules2() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : type ID (',' ID)* ';' -> ^(type ID)+ ;\ntype : 'int' ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "int a,b,c;", this.debug);
        TestRewriteAST.assertEquals((String)"(int a) (int b) (int c)\n", (String)string2);
    }

    public void testCopySemanticsForRules3() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : modifier? type ID (',' ID)* ';' -> ^(type modifier? ID)+ ;\ntype : 'int' ;\nmodifier : 'public' ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "public int a,b,c;", this.debug);
        TestRewriteAST.assertEquals((String)"(int public a) (int public b) (int public c)\n", (String)string2);
    }

    public void testCopySemanticsForRules3Double() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : modifier? type ID (',' ID)* ';' -> ^(type modifier? ID)+ ^(type modifier? ID)+ ;\ntype : 'int' ;\nmodifier : 'public' ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "public int a,b,c;", this.debug);
        TestRewriteAST.assertEquals((String)"(int public a) (int public b) (int public c) (int public a) (int public b) (int public c)\n", (String)string2);
    }

    public void testCopySemanticsForRules4() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {MOD;}\na : modifier? type ID (',' ID)* ';' -> ^(type ^(MOD modifier)? ID)+ ;\ntype : 'int' ;\nmodifier : 'public' ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "public int a,b,c;", this.debug);
        TestRewriteAST.assertEquals((String)"(int (MOD public) a) (int (MOD public) b) (int (MOD public) c)\n", (String)string2);
    }

    public void testCopySemanticsLists() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {MOD;}\na : ID (',' ID)* ';' -> ID+ ID+ ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a,b,c;", this.debug);
        TestRewriteAST.assertEquals((String)"a b c a b c\n", (String)string2);
    }

    public void testCopyRuleLabel() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : x=b -> $x $x;\nb : ID ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a", this.debug);
        TestRewriteAST.assertEquals((String)"a a\n", (String)string2);
    }

    public void testCopyRuleLabel2() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : x=b -> ^($x $x);\nb : ID ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a", this.debug);
        TestRewriteAST.assertEquals((String)"(a a)\n", (String)string2);
    }

    public void testQueueingOfTokens() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : 'int' ID (',' ID)* ';' -> ^('int' ID+) ;\nop : '+'|'-' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "int a,b,c;", this.debug);
        TestRewriteAST.assertEquals((String)"(int a b c)\n", (String)string2);
    }

    public void testCopyOfTokens() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : 'int' ID ';' -> 'int' ID 'int' ID ;\nop : '+'|'-' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "int a;", this.debug);
        TestRewriteAST.assertEquals((String)"int a int a\n", (String)string2);
    }

    public void testTokenCopyInLoop() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : 'int' ID (',' ID)* ';' -> ^('int' ID)+ ;\nop : '+'|'-' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "int a,b,c;", this.debug);
        TestRewriteAST.assertEquals((String)"(int a) (int b) (int c)\n", (String)string2);
    }

    public void testTokenCopyInLoopAgainstTwoOthers() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : 'int' ID ':' INT (',' ID ':' INT)* ';' -> ^('int' ID INT)+ ;\nop : '+'|'-' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "int a:1,b:2,c:3;", this.debug);
        TestRewriteAST.assertEquals((String)"(int a 1) (int b 2) (int c 3)\n", (String)string2);
    }

    public void testListRefdOneAtATime() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID+ -> ID ID ID ;\nop : '+'|'-' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a b c", this.debug);
        TestRewriteAST.assertEquals((String)"a b c\n", (String)string2);
    }

    public void testSplitListWithLabels() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {VAR;}\na : first=ID others+=ID* -> $first VAR $others+ ;\nop : '+'|'-' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a b c", this.debug);
        TestRewriteAST.assertEquals((String)"a VAR b c\n", (String)string2);
    }

    public void testComplicatedMelange() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : A A b=B B b=B c+=C C c+=C D {String s=$D.text;} -> A+ B+ C+ D ;\ntype : 'int' | 'float' ;\nA : 'a' ;\nB : 'b' ;\nC : 'c' ;\nD : 'd' ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a a b b b c c c d", this.debug);
        TestRewriteAST.assertEquals((String)"a a b b b c c c d\n", (String)string2);
    }

    public void testRuleLabel() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : x=b -> $x;\nb : ID ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a", this.debug);
        TestRewriteAST.assertEquals((String)"a\n", (String)string2);
    }

    public void testAmbiguousRule() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID a -> a | INT ;\nID : 'a'..'z'+ ;\nINT: '0'..'9'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc 34", this.debug);
        TestRewriteAST.assertEquals((String)"34\n", (String)string2);
    }

    public void testWeirdRuleRef() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "grammar T;\noptions {output=AST;}\na : ID a -> $a | INT ;\nID : 'a'..'z'+ ;\nINT: '0'..'9'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        Grammar grammar = new Grammar(string);
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        TestRewriteAST.assertEquals((String)("unexpected errors: " + errorQueue), (int)1, (int)errorQueue.errors.size());
    }

    public void testRuleListLabel() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : x+=b x+=b -> $x+;\nb : ID ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a b", this.debug);
        TestRewriteAST.assertEquals((String)"a b\n", (String)string2);
    }

    public void testRuleListLabel2() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : x+=b x+=b -> $x $x*;\nb : ID ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a b", this.debug);
        TestRewriteAST.assertEquals((String)"a b\n", (String)string2);
    }

    public void testOptional() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : x=b (y=b)? -> $x $y?;\nb : ID ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a", this.debug);
        TestRewriteAST.assertEquals((String)"a\n", (String)string2);
    }

    public void testOptional2() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : x=ID (y=b)? -> $x $y?;\nb : ID ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a b", this.debug);
        TestRewriteAST.assertEquals((String)"a b\n", (String)string2);
    }

    public void testOptional3() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : x=ID (y=b)? -> ($x $y)?;\nb : ID ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a b", this.debug);
        TestRewriteAST.assertEquals((String)"a b\n", (String)string2);
    }

    public void testOptional4() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : x+=ID (y=b)? -> ($x $y)?;\nb : ID ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a b", this.debug);
        TestRewriteAST.assertEquals((String)"a b\n", (String)string2);
    }

    public void testOptional5() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : ID -> ID? ;\nb : ID ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a", this.debug);
        TestRewriteAST.assertEquals((String)"a\n", (String)string2);
    }

    public void testArbitraryExprType() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : x+=b x+=b -> {new CommonTree()};\nb : ID ;\nID : 'a'..'z'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a b", this.debug);
        TestRewriteAST.assertEquals((String)"", (String)string2);
    }

    public void testSet() throws Exception {
        String string = "grammar T;\noptions { output = AST; } \na: (INT|ID)+ -> INT+ ID+ ;\nINT: '0'..'9'+;\nID : 'a'..'z'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "2 a 34 de", this.debug);
        TestRewriteAST.assertEquals((String)"2 34 a de\n", (String)string2);
    }

    public void testSet2() throws Exception {
        String string = "grammar T;\noptions { output = AST; } \na: (INT|ID) -> INT? ID? ;\nINT: '0'..'9'+;\nID : 'a'..'z'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "2", this.debug);
        TestRewriteAST.assertEquals((String)"2\n", (String)string2);
    }

    public void testSetWithLabel() throws Exception {
        String string = "grammar T;\noptions { output = AST; } \na : x=(INT|ID) -> $x ;\nINT: '0'..'9'+;\nID : 'a'..'z'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "2", this.debug);
        TestRewriteAST.assertEquals((String)"2\n", (String)string2);
    }

    public void testRewriteAction() throws Exception {
        String string = "grammar T; \noptions { output = AST; }\ntokens { FLOAT; }\nr\n    : INT -> {new CommonTree(new CommonToken(FLOAT,$INT.text+\".0\"))} \n    ; \nINT : '0'..'9'+; \nWS: (' ' | '\\n' | '\\t')+ {$channel = HIDDEN;}; \n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "r", "25", this.debug);
        TestRewriteAST.assertEquals((String)"25.0\n", (String)string2);
    }

    public void testOptionalSubruleWithoutRealElements() throws Exception {
        String string = "grammar T;\noptions {output=AST;} \ntokens {PARMS;} \n\nmodulo \n : 'modulo' ID ('(' parms+ ')')? -> ^('modulo' ID ^(PARMS parms+)?) \n ; \nparms : '#'|ID; \nID : ('a'..'z' | 'A'..'Z')+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "modulo", "modulo abc (x y #)", this.debug);
        TestRewriteAST.assertEquals((String)"(modulo abc (PARMS x y #))\n", (String)string2);
    }

    public void testCardinality() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ntokens {BLOCK;}\na : ID ID INT INT INT -> (ID INT)+;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+; \nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        this.execParser("T.g", string, "TParser", "TLexer", "a", "a b 3 4 5", this.debug);
        String string2 = "org.antlr.runtime.tree.RewriteCardinalityException: token ID";
        String string3 = this.getFirstLineOfException();
        TestRewriteAST.assertEquals((String)string2, (String)string3);
    }

    public void testCardinality2() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID+ -> ID ID ID ;\nop : '+'|'-' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        this.execParser("T.g", string, "TParser", "TLexer", "a", "a b", this.debug);
        String string2 = "org.antlr.runtime.tree.RewriteCardinalityException: token ID";
        String string3 = this.getFirstLineOfException();
        TestRewriteAST.assertEquals((String)string2, (String)string3);
    }

    public void testCardinality3() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID? INT -> ID INT ;\nop : '+'|'-' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        this.execParser("T.g", string, "TParser", "TLexer", "a", "3", this.debug);
        String string2 = "org.antlr.runtime.tree.RewriteEmptyStreamException: token ID";
        String string3 = this.getFirstLineOfException();
        TestRewriteAST.assertEquals((String)string2, (String)string3);
    }

    public void testLoopCardinality() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID? INT -> ID+ INT ;\nop : '+'|'-' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        this.execParser("T.g", string, "TParser", "TLexer", "a", "3", this.debug);
        String string2 = "org.antlr.runtime.tree.RewriteEarlyExitException";
        String string3 = this.getFirstLineOfException();
        TestRewriteAST.assertEquals((String)string2, (String)string3);
    }

    public void testWildcard() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID c=. -> $c;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc 34", this.debug);
        TestRewriteAST.assertEquals((String)"34\n", (String)string2);
    }

    public void testUnknownRule() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "grammar T;\noptions {output=AST;}\na : INT -> ugh ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        Grammar grammar = new Grammar(string);
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 106;
        String string2 = "ugh";
        Object var8_8 = null;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string2, var8_8);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testKnownRuleButNotInLHS() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "grammar T;\noptions {output=AST;}\na : INT -> b ;\nb : 'b' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        Grammar grammar = new Grammar(string);
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 136;
        String string2 = "b";
        Object var8_8 = null;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string2, var8_8);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testUnknownToken() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "grammar T;\noptions {output=AST;}\na : INT -> ICK ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        Grammar grammar = new Grammar(string);
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 135;
        String string2 = "ICK";
        Object var8_8 = null;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string2, var8_8);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testUnknownLabel() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "grammar T;\noptions {output=AST;}\na : INT -> $foo ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        Grammar grammar = new Grammar(string);
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 137;
        String string2 = "foo";
        Object var8_8 = null;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string2, var8_8);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testUnknownCharLiteralToken() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "grammar T;\noptions {output=AST;}\na : INT -> 'a' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        Grammar grammar = new Grammar(string);
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 135;
        String string2 = "'a'";
        Object var8_8 = null;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string2, var8_8);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testUnknownStringLiteralToken() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        String string = "grammar T;\noptions {output=AST;}\na : INT -> 'foo' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        Grammar grammar = new Grammar(string);
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        int n = 135;
        String string2 = "'foo'";
        Object var8_8 = null;
        GrammarSemanticsMessage grammarSemanticsMessage = new GrammarSemanticsMessage(n, grammar, null, string2, var8_8);
        this.checkError(errorQueue, grammarSemanticsMessage);
    }

    public void testExtraTokenInSimpleDecl() throws Exception {
        String string = "grammar foo;\noptions {output=AST;}\ntokens {EXPR;}\ndecl : type ID '=' INT ';' -> ^(EXPR type ID INT) ;\ntype : 'int' | 'float' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("foo.g", string, "fooParser", "fooLexer", "decl", "int 34 x=1;", this.debug);
        TestRewriteAST.assertEquals((String)"line 1:4 extraneous input '34' expecting ID\n", (String)this.stderr);
        TestRewriteAST.assertEquals((String)"(EXPR int x 1)\n", (String)string2);
    }

    public void testMissingIDInSimpleDecl() throws Exception {
        String string = "grammar foo;\noptions {output=AST;}\ntokens {EXPR;}\ndecl : type ID '=' INT ';' -> ^(EXPR type ID INT) ;\ntype : 'int' | 'float' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("foo.g", string, "fooParser", "fooLexer", "decl", "int =1;", this.debug);
        TestRewriteAST.assertEquals((String)"line 1:4 missing ID at '='\n", (String)this.stderr);
        TestRewriteAST.assertEquals((String)"(EXPR int <missing ID> 1)\n", (String)string2);
    }

    public void testMissingSetInSimpleDecl() throws Exception {
        String string = "grammar foo;\noptions {output=AST;}\ntokens {EXPR;}\ndecl : type ID '=' INT ';' -> ^(EXPR type ID INT) ;\ntype : 'int' | 'float' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("foo.g", string, "fooParser", "fooLexer", "decl", "x=1;", this.debug);
        TestRewriteAST.assertEquals((String)"line 1:0 mismatched input 'x' expecting set null\n", (String)this.stderr);
        TestRewriteAST.assertEquals((String)"(EXPR <error: x> x 1)\n", (String)string2);
    }

    public void testMissingTokenGivesErrorNode() throws Exception {
        String string = "grammar foo;\noptions {output=AST;}\na : ID INT -> ID INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("foo.g", string, "fooParser", "fooLexer", "a", "abc", this.debug);
        TestRewriteAST.assertEquals((String)"line 0:-1 missing INT at '<EOF>'\n", (String)this.stderr);
        TestRewriteAST.assertEquals((String)"abc <missing INT>\n", (String)string2);
    }

    public void testExtraTokenGivesErrorNode() throws Exception {
        String string = "grammar foo;\noptions {output=AST;}\na : b c -> b c;\nb : ID -> ID ;\nc : INT -> INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("foo.g", string, "fooParser", "fooLexer", "a", "abc ick 34", this.debug);
        TestRewriteAST.assertEquals((String)"line 1:4 extraneous input 'ick' expecting INT\n", (String)this.stderr);
        TestRewriteAST.assertEquals((String)"abc 34\n", (String)string2);
    }

    public void testMissingFirstTokenGivesErrorNode() throws Exception {
        String string = "grammar foo;\noptions {output=AST;}\na : ID INT -> ID INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("foo.g", string, "fooParser", "fooLexer", "a", "34", this.debug);
        TestRewriteAST.assertEquals((String)"line 1:0 missing ID at '34'\n", (String)this.stderr);
        TestRewriteAST.assertEquals((String)"<missing ID> 34\n", (String)string2);
    }

    public void testMissingFirstTokenGivesErrorNode2() throws Exception {
        String string = "grammar foo;\noptions {output=AST;}\na : b c -> b c;\nb : ID -> ID ;\nc : INT -> INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("foo.g", string, "fooParser", "fooLexer", "a", "34", this.debug);
        TestRewriteAST.assertEquals((String)"line 1:0 missing ID at '34'\n", (String)this.stderr);
        TestRewriteAST.assertEquals((String)"<missing ID> 34\n", (String)string2);
    }

    public void testNoViableAltGivesErrorNode() throws Exception {
        String string = "grammar foo;\noptions {output=AST;}\na : b -> b | c -> c;\nb : ID -> ID ;\nc : INT -> INT ;\nID : 'a'..'z'+ ;\nS : '*' ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("foo.g", string, "fooParser", "fooLexer", "a", "*", this.debug);
        TestRewriteAST.assertEquals((String)"line 1:0 no viable alternative at input '*'\n", (String)this.stderr);
        TestRewriteAST.assertEquals((String)"<unexpected: [@0,0:0='*',<6>,1:0], resync=*>\n", (String)string2);
    }

    protected void checkError(ErrorQueue errorQueue, GrammarSemanticsMessage grammarSemanticsMessage) throws Exception {
        Message message = null;
        for (int i = 0; i < errorQueue.errors.size(); ++i) {
            Message message2 = (Message)errorQueue.errors.get(i);
            if (message2.msgID != grammarSemanticsMessage.msgID) continue;
            message = message2;
        }
        TestRewriteAST.assertTrue((String)("no error; " + grammarSemanticsMessage.msgID + " expected"), (errorQueue.errors.size() > 0 ? 1 : 0) != 0);
        TestRewriteAST.assertTrue((String)("too many errors; " + errorQueue.errors), (errorQueue.errors.size() <= 1 ? 1 : 0) != 0);
        TestRewriteAST.assertNotNull((String)("couldn't find expected error: " + grammarSemanticsMessage.msgID), (Object)message);
        TestRewriteAST.assertTrue((String)"error is not a GrammarSemanticsMessage", (boolean)(message instanceof GrammarSemanticsMessage));
        TestRewriteAST.assertEquals((Object)grammarSemanticsMessage.arg, (Object)message.arg);
        TestRewriteAST.assertEquals((Object)grammarSemanticsMessage.arg2, (Object)message.arg2);
        ErrorManager.resetErrorState();
    }
}

