/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.DefaultMuleException;
import org.mule.transport.file.InputStreamCloseListener;
import org.mule.transport.file.i18n.FileMessages;
import org.mule.util.FileUtils;

class ReceiverFileInputStream
extends FileInputStream {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private File currentFile;
    private boolean deleteOnClose;
    private File moveToOnClose;
    private boolean streamProcessingError;
    private InputStreamCloseListener closeListener;

    public ReceiverFileInputStream(File currentFile, boolean deleteOnClose, File moveToOnClose) throws FileNotFoundException {
        super(currentFile);
        this.currentFile = currentFile;
        this.deleteOnClose = deleteOnClose;
        this.moveToOnClose = moveToOnClose;
    }

    public ReceiverFileInputStream(File sourceFile, boolean deleteOnClose, File destinationFile, InputStreamCloseListener closeListener) throws FileNotFoundException {
        this(sourceFile, deleteOnClose, destinationFile);
        this.closeListener = closeListener;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (!this.streamProcessingError) {
            if (this.moveToOnClose != null) {
                if (!FileUtils.moveFileWithCopyFallback((File)this.currentFile, (File)this.moveToOnClose)) {
                    this.logger.warn((Object)String.format("Failed to move file from %s to %s\n", this.currentFile.getPath(), this.moveToOnClose.getPath()));
                }
            } else if (this.deleteOnClose && !this.currentFile.delete()) {
                try {
                    throw new DefaultMuleException(FileMessages.failedToDeleteFile(this.currentFile));
                }
                catch (DefaultMuleException e) {
                    IOException e2 = new IOException();
                    e2.initCause(e);
                    throw e2;
                }
            }
        }
        if (this.closeListener != null) {
            this.closeListener.fileClose(this.currentFile);
        }
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public boolean isStreamProcessingError() {
        return this.streamProcessingError;
    }

    public void setStreamProcessingError(boolean streamProcessingError) {
        this.streamProcessingError = streamProcessingError;
    }
}

