/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.listener;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.mule.api.MuleContext;
import org.mule.api.context.notification.ConnectionNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.ConnectionNotification;
import org.mule.context.notification.NotificationException;
import org.mule.util.concurrent.Latch;

public class ConnectionListener {
    private CountDownLatch notificationReceivedLatch = new Latch();
    private int timeout = 10000;
    private int expectedAction = 701;

    public ConnectionListener(MuleContext muleContext) {
        try {
            muleContext.registerListener((ServerNotificationListener)new ConnectionNotificationListener<ConnectionNotification>(){

                public void onNotification(ConnectionNotification notification) {
                    if (notification.getAction() == ConnectionListener.this.expectedAction) {
                        ConnectionListener.this.notificationReceivedLatch.countDown();
                    }
                }
            });
        }
        catch (NotificationException e) {
            throw new RuntimeException(e);
        }
    }

    public void waitUntilNotificationsAreReceived() {
        try {
            if (!this.notificationReceivedLatch.await(this.timeout, TimeUnit.MILLISECONDS)) {
                Assert.fail((String)"Expected notifications were not received");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public ConnectionListener setNumberOfExecutionsRequired(int numberOfExecutionsRequired) {
        this.notificationReceivedLatch = new CountDownLatch(numberOfExecutionsRequired);
        return this;
    }

    public ConnectionListener setTimeoutInMillis(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public ConnectionListener setExpectedAction(int expectedAction) {
        this.expectedAction = expectedAction;
        return this;
    }
}

