/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.xa;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.transport.jms.xa.ConnectionInvocationHandler;
import org.mule.util.xa.XaResourceFactoryHolder;

public class ConnectionFactoryWrapper
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory {
    protected static final transient Log logger = LogFactory.getLog(ConnectionFactoryWrapper.class);
    protected final Object factory;
    private Boolean sameRMOverrideValue;

    public ConnectionFactoryWrapper(Object factory) {
        this(factory, null);
    }

    public ConnectionFactoryWrapper(Object factory, Boolean sameRMOverrideValue) {
        this.factory = factory;
        this.sameRMOverrideValue = sameRMOverrideValue;
    }

    public Connection createConnection() throws JMSException {
        XAConnection xac = ((XAConnectionFactory)this.factory).createXAConnection();
        Connection proxy = (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class, XaResourceFactoryHolder.class}, (InvocationHandler)((Object)new ConnectionInvocationHandler(xac, this.sameRMOverrideValue)));
        return proxy;
    }

    public Connection createConnection(String username, String password) throws JMSException {
        XAConnection xac = ((XAConnectionFactory)this.factory).createXAConnection(username, password);
        Connection proxy = (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class, XaResourceFactoryHolder.class}, (InvocationHandler)((Object)new ConnectionInvocationHandler(xac, this.sameRMOverrideValue)));
        return proxy;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        XAQueueConnection xaqc = ((XAQueueConnectionFactory)this.factory).createXAQueueConnection();
        QueueConnection proxy = (QueueConnection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{QueueConnection.class, XaResourceFactoryHolder.class}, (InvocationHandler)((Object)new ConnectionInvocationHandler(xaqc, this.sameRMOverrideValue)));
        return proxy;
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        XAQueueConnection xaqc = ((XAQueueConnectionFactory)this.factory).createXAQueueConnection(username, password);
        QueueConnection proxy = (QueueConnection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{QueueConnection.class, XaResourceFactoryHolder.class}, (InvocationHandler)((Object)new ConnectionInvocationHandler(xaqc, this.sameRMOverrideValue)));
        return proxy;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        XATopicConnection xatc = ((XATopicConnectionFactory)this.factory).createXATopicConnection();
        TopicConnection proxy = (TopicConnection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{TopicConnection.class, XaResourceFactoryHolder.class}, (InvocationHandler)((Object)new ConnectionInvocationHandler(xatc, this.sameRMOverrideValue)));
        return proxy;
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        XATopicConnection xatc = ((XATopicConnectionFactory)this.factory).createXATopicConnection(username, password);
        TopicConnection proxy = (TopicConnection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{TopicConnection.class, XaResourceFactoryHolder.class}, (InvocationHandler)((Object)new ConnectionInvocationHandler(xatc, this.sameRMOverrideValue)));
        return proxy;
    }
}

