/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.message;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.io.DelegatingInputStream;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.StringMapImpl;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageImpl
extends StringMapImpl
implements Message {
    private static final Class<?>[] DEFAULT_CONTENTS;
    private static final int DEFAULT_CONTENTS_LENGTH;
    private Exchange exchange;
    private String id;
    private InterceptorChain interceptorChain;
    private Object[] defaultContents = new Object[DEFAULT_CONTENTS_LENGTH];
    private Map<Class<?>, Object> contents;
    private Map<String, Object> contextCache;

    public MessageImpl() {
    }

    public MessageImpl(Message m) {
        super(m);
        if (!(m instanceof MessageImpl)) {
            throw new RuntimeException("Not a MessageImpl! " + m.getClass());
        }
        MessageImpl impl = (MessageImpl)m;
        this.exchange = impl.getExchange();
        this.id = impl.id;
        this.interceptorChain = impl.interceptorChain;
        this.defaultContents = impl.defaultContents;
        this.contents = impl.contents;
        this.contextCache = impl.contextCache;
    }

    @Override
    public Collection<Attachment> getAttachments() {
        return CastUtils.cast((Collection)((Collection)this.get(ATTACHMENTS)));
    }

    @Override
    public void setAttachments(Collection<Attachment> attachments) {
        this.put(ATTACHMENTS, (Object)attachments);
    }

    public String getAttachmentMimeType() {
        return null;
    }

    @Override
    public Destination getDestination() {
        return this.get(Destination.class);
    }

    @Override
    public Exchange getExchange() {
        return this.exchange;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public InterceptorChain getInterceptorChain() {
        return this.interceptorChain;
    }

    @Override
    public <T> T getContent(Class<T> format) {
        for (int x = 0; x < DEFAULT_CONTENTS_LENGTH; ++x) {
            if (DEFAULT_CONTENTS[x] != format) continue;
            return (T)this.defaultContents[x];
        }
        return (T)(this.contents == null ? null : this.contents.get(format));
    }

    @Override
    public <T> void setContent(Class<T> format, Object content) {
        for (int x = 0; x < DEFAULT_CONTENTS_LENGTH; ++x) {
            if (DEFAULT_CONTENTS[x] != format) continue;
            this.defaultContents[x] = content;
            return;
        }
        if (this.contents == null) {
            this.contents = new IdentityHashMap(6);
        }
        this.contents.put(format, content);
    }

    @Override
    public <T> void removeContent(Class<T> format) {
        for (int x = 0; x < DEFAULT_CONTENTS_LENGTH; ++x) {
            if (DEFAULT_CONTENTS[x] != format) continue;
            this.defaultContents[x] = null;
            return;
        }
        if (this.contents != null) {
            this.contents.remove(format);
        }
    }

    @Override
    public Set<Class<?>> getContentFormats() {
        HashSet<Object> c = this.contents == null ? new HashSet() : new HashSet(this.contents.keySet());
        for (int x = 0; x < DEFAULT_CONTENTS_LENGTH; ++x) {
            if (this.defaultContents[x] == null) continue;
            c.add(DEFAULT_CONTENTS[x]);
        }
        return c;
    }

    public void setDestination(Destination d) {
        this.put(Destination.class, d);
    }

    @Override
    public void setExchange(Exchange e) {
        this.exchange = e;
    }

    @Override
    public void setId(String i) {
        this.id = i;
    }

    @Override
    public void setInterceptorChain(InterceptorChain ic) {
        this.interceptorChain = ic;
    }

    @Override
    public Object put(String key, Object value) {
        if (this.contextCache != null) {
            this.contextCache.put(key, value);
        }
        return super.put(key, value);
    }

    @Override
    public Object getContextualProperty(String key) {
        if (this.contextCache == null) {
            this.calcContextCache();
        }
        return this.contextCache.get(key);
    }

    private void calcContextCache() {
        HashMap<String, Object> o = new HashMap<String, Object>(){

            @Override
            public void putAll(Map<? extends String, ? extends Object> m) {
                if (m != null && m.size() > 0) {
                    super.putAll(m);
                }
            }
        };
        Exchange ex = this.getExchange();
        if (ex != null) {
            Endpoint ep;
            Service sv;
            Bus b = ex.getBus();
            if (b != null) {
                o.putAll(b.getProperties());
            }
            if ((sv = ex.getService()) != null) {
                o.putAll(sv);
            }
            if ((ep = ex.getEndpoint()) != null) {
                EndpointInfo ei = ep.getEndpointInfo();
                if (ei != null) {
                    o.putAll(ep.getEndpointInfo().getBinding().getProperties());
                    o.putAll(ep.getEndpointInfo().getProperties());
                }
                o.putAll(ep);
            }
        }
        o.putAll(ex);
        o.putAll(this);
        this.contextCache = o;
    }

    public static void copyContent(Message m1, Message m2) {
        for (Class<?> c : m1.getContentFormats()) {
            m2.setContent(c, m1.getContent(c));
        }
    }

    @Override
    public void resetContextCache() {
        if (this.contextCache != null) {
            this.contextCache = null;
        }
    }

    @Override
    public void setContextualProperty(String key, Object v) {
        if (this.contextCache != null && !this.containsKey(key)) {
            this.contextCache.put(key, v);
        }
    }

    static {
        Class[] tmps;
        try {
            Class<?> cls = Class.forName("javax.xml.soap.SOAPMessage");
            tmps = new Class[]{XMLStreamReader.class, XMLStreamWriter.class, InputStream.class, OutputStream.class, List.class, Exception.class, Node.class, DelegatingInputStream.class, cls};
        }
        catch (Throwable e) {
            tmps = new Class[]{XMLStreamReader.class, XMLStreamWriter.class, InputStream.class, OutputStream.class, List.class, Exception.class, Node.class, DelegatingInputStream.class};
        }
        DEFAULT_CONTENTS = tmps;
        DEFAULT_CONTENTS_LENGTH = tmps.length;
    }
}

