/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.tcp.protocols;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.apache.log4j.Logger;
import org.mule.transport.tcp.protocols.LengthProtocol;

public class CustomClassLoadingLengthProtocol
extends LengthProtocol {
    private final Logger logger = Logger.getLogger(this.getClass());
    private ClassLoader classLoader;

    @Override
    public Object read(InputStream is) throws IOException {
        byte[] bytes = (byte[])super.read(is);
        if (bytes == null) {
            return null;
        }
        ClassLoaderObjectInputStream classLoaderIS = new ClassLoaderObjectInputStream(this.getClassLoader(), is);
        try {
            Object object = classLoaderIS.readObject();
            return object;
        }
        catch (ClassNotFoundException e) {
            this.logger.warn((Object)e.getMessage());
            IOException iox = new IOException();
            iox.initCause(e);
            throw iox;
        }
        finally {
            classLoaderIS.close();
        }
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = this.getClass().getClassLoader();
        }
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

