/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.drools.common.InternalFactHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualityKey
implements Externalizable {
    public static final int STATED = 1;
    public static final int JUSTIFIED = 2;
    private InternalFactHandle handle;
    private List<InternalFactHandle> instances;
    private int hashCode;
    private int status;

    public EqualityKey() {
    }

    public EqualityKey(InternalFactHandle handle) {
        this.handle = handle;
        this.hashCode = handle.getObjectHashCode();
    }

    public EqualityKey(InternalFactHandle handle, int status) {
        this.handle = handle;
        this.hashCode = handle.getObjectHashCode();
        this.status = status;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.handle = (InternalFactHandle)in.readObject();
        this.instances = (List)in.readObject();
        this.hashCode = in.readInt();
        this.status = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.handle);
        out.writeObject(this.instances);
        out.writeInt(this.hashCode);
        out.writeInt(this.status);
    }

    public InternalFactHandle getFactHandle() {
        return this.handle;
    }

    public List<InternalFactHandle> getOtherFactHandle() {
        return this.instances;
    }

    public void addFactHandle(InternalFactHandle handle) {
        if (this.instances == null) {
            this.instances = new ArrayList<InternalFactHandle>();
        }
        this.instances.add(handle);
    }

    public void removeFactHandle(InternalFactHandle handle) {
        if (this.handle == handle) {
            if (this.instances == null) {
                this.handle = null;
            } else {
                this.handle = this.instances.remove(0);
                if (this.instances.isEmpty()) {
                    this.instances = null;
                }
            }
        } else {
            this.instances.remove(handle);
            if (this.instances.isEmpty()) {
                this.instances = null;
            }
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int size() {
        if (this.instances != null) {
            return this.instances.size() + 1;
        }
        return this.handle != null ? 1 : 0;
    }

    public boolean isEmpty() {
        return this.handle == null;
    }

    public String toString() {
        String str = null;
        switch (this.status) {
            case 1: {
                str = "STATED";
                break;
            }
            case 2: {
                str = "JUSTIFIED";
            }
        }
        return "[FactStatus status=" + this.status + "]";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof EqualityKey) {
            return this == object;
        }
        return this.handle.getObject().equals(object);
    }
}

