/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet.jetty;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import javax.servlet.Servlet;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppLifeCycle;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.deploy.graph.Node;
import org.eclipse.jetty.deploy.providers.WebAppProvider;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.notification.MuleContextNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.ReplyToHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.MuleContextNotification;
import org.mule.context.notification.NotificationException;
import org.mule.transport.AbstractConnector;
import org.mule.transport.servlet.JarResourceServlet;
import org.mule.transport.servlet.MuleReceiverServlet;
import org.mule.transport.servlet.MuleServletContextListener;
import org.mule.transport.servlet.jetty.AbstractConnectorHolder;
import org.mule.transport.servlet.jetty.ConnectorHolder;
import org.mule.transport.servlet.jetty.JettyContinuationsReceiverServlet;
import org.mule.transport.servlet.jetty.JettyContinuationsReplyToHandler;
import org.mule.transport.servlet.jetty.JettyHttpMessageReceiver;
import org.mule.transport.servlet.jetty.JettyLogger;
import org.mule.transport.servlet.jetty.JettyReceiverServlet;
import org.mule.transport.servlet.jetty.JettyWebappServerAgent;
import org.mule.transport.servlet.jetty.WebappsConfiguration;
import org.mule.transport.tcp.TcpPropertyHelper;
import org.mule.transport.tcp.i18n.TcpMessages;
import org.mule.util.ClassUtils;
import org.mule.util.IOUtils;
import org.mule.util.StringMessageUtils;
import org.mule.util.StringUtils;

public class JettyHttpConnector
extends AbstractConnector {
    public static final String ROOT = "/";
    public static final String JETTY = "jetty";
    public static final String MULE_CONTEXT_ATTRIBUTE = "muleContext";
    private Server httpServer;
    private String configFile;
    private JettyReceiverServlet receiverServlet;
    private boolean useContinuations = false;
    private int acceptors = 1;
    private String resourceBase;
    private WebappsConfiguration webappsConfiguration;
    protected HashMap<String, ConnectorHolder> holders = new HashMap();
    private ContextHandlerCollection contexts;

    public JettyHttpConnector(MuleContext context) {
        super(context);
        this.setupJettyLogging();
        this.registerSupportedProtocol("http");
        this.registerSupportedProtocol(JETTY);
        this.setInitialStateStopped(true);
    }

    protected void setupJettyLogging() {
        if (!(Log.getLog() instanceof JettyLogger)) {
            Log.setLog((Logger)new JettyLogger());
        }
    }

    public String getProtocol() {
        return JETTY;
    }

    protected void doInitialise() throws InitialisationException {
        this.httpServer = new Server();
        this.contexts = new ContextHandlerCollection();
        this.httpServer.setHandler((Handler)this.contexts);
        if (this.webappsConfiguration != null) {
            DeploymentManager deploymentManager = new DeploymentManager();
            WebAppProvider webAppProvider = new WebAppProvider(){

                public ContextHandler createContextHandler(App app) throws Exception {
                    WebAppContext webAppContext = (WebAppContext)super.createContextHandler(app);
                    if (JettyHttpConnector.this.webappsConfiguration.getServerClasses() != null) {
                        webAppContext.setServerClasses(JettyHttpConnector.this.webappsConfiguration.getServerClasses());
                    }
                    if (JettyHttpConnector.this.webappsConfiguration.getSystemClasses() != null) {
                        webAppContext.setSystemClasses(JettyHttpConnector.this.webappsConfiguration.getSystemClasses());
                    }
                    return webAppContext;
                }
            };
            org.eclipse.jetty.server.AbstractConnector jettyConnector = this.createJettyConnector();
            jettyConnector.setHost(this.webappsConfiguration.getHost());
            jettyConnector.setPort(this.webappsConfiguration.getPort());
            deploymentManager.setContexts(this.contexts);
            deploymentManager.addAppProvider((AppProvider)webAppProvider);
            deploymentManager.addLifeCycleBinding(new AppLifeCycle.Binding((Connector)jettyConnector){
                final /* synthetic */ Connector val$jettyConnector;
                {
                    this.val$jettyConnector = connector;
                }

                public String[] getBindingTargets() {
                    return new String[]{"deploying"};
                }

                public void processBinding(Node node, App app) throws Exception {
                    ContextHandler contextHandler = app.getContextHandler();
                    if (contextHandler instanceof WebAppContext) {
                        WebAppContext webapp = (WebAppContext)contextHandler;
                        File workDir = new File(JettyHttpConnector.this.muleContext.getConfiguration().getWorkingDirectory(), "_exploded_wars" + webapp.getContextPath());
                        workDir.mkdirs();
                        webapp.setTempDirectory(workDir);
                        webapp.setAttribute(JettyHttpConnector.MULE_CONTEXT_ATTRIBUTE, (Object)JettyHttpConnector.this.muleContext);
                        webapp.setConnectorNames(new String[]{this.val$jettyConnector.getName()});
                        if (JettyHttpConnector.this.logger.isInfoEnabled()) {
                            String msg = String.format("Will deploy a web app at %s://%s%s%s", "http", this.val$jettyConnector.getHost(), this.val$jettyConnector.getPort() == 80 ? "" : ":" + this.val$jettyConnector.getPort(), webapp.getContextPath());
                            JettyHttpConnector.this.logger.info((Object)StringMessageUtils.getBoilerPlate((String)msg, (char)'*', (int)70));
                        }
                        return;
                    }
                }
            });
            String webAppDir = this.webappsConfiguration.getDirectory();
            if (StringUtils.isBlank((String)webAppDir)) {
                String appDir = (String)this.muleContext.getRegistry().get("app.home");
                webAppDir = appDir + "/webapps";
            }
            if (this.configFile == null) {
                URL muleDefaults = ClassUtils.getResource((String)"org/mule/transport/jetty/webdefault.xml", ((Object)((Object)this)).getClass());
                webAppProvider.setDefaultsDescriptor(muleDefaults.toExternalForm());
            }
            webAppProvider.setMonitoredDirName(webAppDir);
            webAppProvider.setExtractWars(true);
            webAppProvider.setParentLoaderPriority(false);
            String[] confClasses = new String[]{WebInfConfiguration.class.getName(), WebXmlConfiguration.class.getName()};
            webAppProvider.setConfigurationClasses(confClasses);
            webAppProvider.setDeploymentManager(deploymentManager);
            this.httpServer.addBean((Object)deploymentManager);
            this.httpServer.addConnector((Connector)jettyConnector);
        }
        this.initialiseFromConfigFile();
        try {
            this.muleContext.registerListener((ServerNotificationListener)new MuleContextNotificationListener<MuleContextNotification>(){

                public void onNotification(MuleContextNotification notification) {
                    if (notification.getAction() == 104) {
                        JettyHttpConnector.this.setInitialStateStopped(false);
                        try {
                            JettyHttpConnector.this.start();
                            JettyWebappServerAgent agent = (JettyWebappServerAgent)JettyHttpConnector.this.muleContext.getRegistry().lookupAgent("zzz_last_jetty-webapp-agent");
                            if (agent != null) {
                                agent.onJettyConnectorStarted(JettyHttpConnector.this);
                            }
                        }
                        catch (MuleException e) {
                            throw new MuleRuntimeException(CoreMessages.failedToStart((String)JettyHttpConnector.this.getName()), (Throwable)e);
                        }
                    }
                }
            });
        }
        catch (NotificationException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected void addHandler(Handler handler) {
        this.contexts.addHandler(handler);
    }

    protected void initialiseFromConfigFile() throws InitialisationException {
        if (this.configFile == null) {
            return;
        }
        try {
            InputStream is = IOUtils.getResourceAsStream((String)this.configFile, ((Object)((Object)this)).getClass());
            XmlConfiguration config = new XmlConfiguration(is);
            String appHome = (String)this.muleContext.getRegistry().lookupObject("app.home");
            if (appHome == null) {
                appHome = System.getProperty("app.home");
            }
            if (appHome != null) {
                config.getProperties().put("app.home", appHome);
            }
            config.configure((Object)this.httpServer);
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected void doDispose() {
        this.holders.clear();
    }

    protected void doStart() throws MuleException {
        try {
            this.httpServer.start();
            for (ConnectorHolder contextHolder : this.holders.values()) {
                contextHolder.start();
            }
        }
        catch (Exception e) {
            throw new LifecycleException(CoreMessages.failedToStart((String)"Jetty Http Receiver"), (Throwable)e, (Object)this);
        }
    }

    protected void doStop() throws MuleException {
        try {
            this.httpServer.stop();
            for (ConnectorHolder connectorRef : this.holders.values()) {
                connectorRef.stop();
            }
        }
        catch (Exception e) {
            throw new LifecycleException(CoreMessages.failedToStop((String)"Jetty Http Receiver"), (Throwable)e, (Object)this);
        }
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected MessageReceiver createReceiver(FlowConstruct flowConstruct, InboundEndpoint endpoint) throws Exception {
        MessageReceiver receiver = super.createReceiver(flowConstruct, endpoint);
        this.registerJettyEndpoint(receiver, endpoint);
        return receiver;
    }

    protected org.eclipse.jetty.server.AbstractConnector createJettyConnector() {
        SelectChannelConnector cnn = new SelectChannelConnector();
        cnn.setAcceptors(this.getAcceptors());
        return cnn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(MessageReceiver receiver) throws MuleException {
        String connectorKey = this.getHolderKey((ImmutableEndpoint)receiver.getEndpoint());
        JettyHttpConnector jettyHttpConnector = this;
        synchronized (jettyHttpConnector) {
            ConnectorHolder connectorRef = this.holders.get(connectorKey);
            if (connectorRef != null && !connectorRef.isReferenced()) {
                this.getHttpServer().removeConnector(connectorRef.getConnector());
                this.holders.remove(connectorKey);
                connectorRef.stop();
            }
        }
    }

    public Server getHttpServer() {
        return this.httpServer;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public JettyReceiverServlet getReceiverServlet() {
        return this.receiverServlet;
    }

    public void setReceiverServlet(JettyReceiverServlet receiverServlet) {
        this.receiverServlet = receiverServlet;
    }

    public ReplyToHandler getReplyToHandler(ImmutableEndpoint endpoint) {
        if (this.isUseContinuations()) {
            return new JettyContinuationsReplyToHandler(this.muleContext);
        }
        return super.getReplyToHandler(endpoint);
    }

    public boolean isUseContinuations() {
        return this.useContinuations;
    }

    public void setUseContinuations(boolean useContinuations) {
        this.useContinuations = useContinuations;
    }

    public int getAcceptors() {
        return this.acceptors;
    }

    public void setAcceptors(int acceptors) {
        this.acceptors = acceptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectorHolder<? extends MuleReceiverServlet, ? extends JettyHttpMessageReceiver> registerJettyEndpoint(MessageReceiver receiver, InboundEndpoint endpoint) throws MuleException {
        ConnectorHolder holder;
        String connectorKey = this.getHolderKey((ImmutableEndpoint)endpoint);
        JettyHttpConnector jettyHttpConnector = this;
        synchronized (jettyHttpConnector) {
            holder = this.holders.get(connectorKey);
            if (holder == null) {
                org.eclipse.jetty.server.AbstractConnector connector = this.createJettyConnector();
                connector.setPort(endpoint.getEndpointURI().getPort());
                String host = endpoint.getEndpointURI().getHost();
                if ("localhost".equalsIgnoreCase(host) && TcpPropertyHelper.isBindingLocalhostToAllLocalInterfaces()) {
                    this.logger.warn((Object)TcpMessages.localhostBoundToAllLocalInterfaces());
                    host = "0.0.0.0";
                }
                connector.setHost(host);
                this.getHttpServer().addConnector((Connector)connector);
                holder = this.createContextHolder((Connector)connector, receiver.getEndpoint(), receiver);
                this.holders.put(connectorKey, holder);
                if (this.isStarted()) {
                    holder.start();
                }
            } else {
                holder.addReceiver(receiver);
            }
        }
        return holder;
    }

    protected ConnectorHolder createContextHolder(Connector connector, InboundEndpoint endpoint, MessageReceiver receiver) {
        return new MuleReceiverConnectorHolder(connector, (JettyReceiverServlet)this.createServlet(connector, (ImmutableEndpoint)endpoint), (JettyHttpMessageReceiver)receiver);
    }

    protected Servlet createServlet(Connector connector, ImmutableEndpoint endpoint) {
        JettyReceiverServlet servlet = this.getReceiverServlet() == null ? (this.isUseContinuations() ? new JettyContinuationsReceiverServlet() : new JettyReceiverServlet()) : this.getReceiverServlet();
        String path = endpoint.getEndpointURI().getPath();
        if (StringUtils.isBlank((String)path)) {
            path = ROOT;
        }
        if (this.resourceBase != null) {
            ResourceHandler resourceHandler = new ResourceHandler();
            ContextHandler resourceContextHandler = new ContextHandler((HandlerContainer)this.contexts, path);
            resourceHandler.setResourceBase(this.resourceBase);
            resourceContextHandler.setHandler((Handler)resourceHandler);
        }
        ServletContextHandler servletContext = new ServletContextHandler((HandlerContainer)this.contexts, ROOT, 0);
        servletContext.addEventListener((EventListener)new MuleServletContextListener(this.muleContext, this.getName()));
        servletContext.setConnectorNames(new String[]{connector.getName()});
        ServletHolder holder = new ServletHolder();
        holder.setServlet((Servlet)servlet);
        servletContext.addServlet(holder, "/*");
        servletContext.addServlet(JarResourceServlet.class, "/mule-resource/*");
        this.addHandler((Handler)servletContext);
        return servlet;
    }

    protected String getHolderKey(ImmutableEndpoint endpoint) {
        return endpoint.getProtocol() + ":" + endpoint.getEndpointURI().getHost() + ":" + endpoint.getEndpointURI().getPort();
    }

    public String getResourceBase() {
        return this.resourceBase;
    }

    public void setResourceBase(String resourceBase) {
        this.resourceBase = resourceBase;
    }

    public WebappsConfiguration getWebappsConfiguration() {
        return this.webappsConfiguration;
    }

    public void setWebappsConfiguration(WebappsConfiguration webappsConfiguration) {
        this.webappsConfiguration = webappsConfiguration;
    }

    public boolean canHostFullWars() {
        return true;
    }

    public class MuleReceiverConnectorHolder
    extends AbstractConnectorHolder<JettyReceiverServlet, JettyHttpMessageReceiver> {
        List<MessageReceiver> messageReceivers;

        public MuleReceiverConnectorHolder(Connector connector, JettyReceiverServlet servlet, JettyHttpMessageReceiver receiver) {
            super(connector, servlet, receiver);
            this.messageReceivers = new ArrayList<MessageReceiver>();
            this.addReceiver(receiver);
        }

        @Override
        public boolean isReferenced() {
            return this.messageReceivers.size() > 0;
        }

        @Override
        public void addReceiver(JettyHttpMessageReceiver receiver) {
            this.messageReceivers.add((MessageReceiver)receiver);
            if (this.started) {
                ((JettyReceiverServlet)((Object)this.getServlet())).addReceiver((MessageReceiver)receiver);
            }
        }

        @Override
        public void removeReceiver(JettyHttpMessageReceiver receiver) {
            this.messageReceivers.remove((Object)receiver);
            ((JettyReceiverServlet)((Object)this.getServlet())).removeReceiver((MessageReceiver)receiver);
        }

        @Override
        public void start() throws MuleException {
            super.start();
            for (MessageReceiver receiver : this.messageReceivers) {
                ((JettyReceiverServlet)this.servlet).addReceiver(receiver);
            }
        }

        @Override
        public void stop() throws MuleException {
            super.stop();
            for (MessageReceiver receiver : this.messageReceivers) {
                ((JettyReceiverServlet)this.servlet).removeReceiver(receiver);
            }
        }
    }
}

