/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet.jetty;

import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.webapp.WebAppContext;
import org.mule.AbstractAgent;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.transport.servlet.jetty.JettyHttpConnector;
import org.mule.util.StringUtils;

public class JettyWebappServerAgent
extends AbstractAgent {
    public static final String NAME = "zzz_last_jetty-webapp-agent";
    protected SortedSet<String> webapps = new TreeSet<String>();

    public JettyWebappServerAgent() {
        super(NAME);
    }

    protected JettyWebappServerAgent(String name) {
        super(name);
    }

    public void dispose() {
        this.webapps.clear();
    }

    public void initialise() throws InitialisationException {
    }

    public void start() throws MuleException {
        Map connectorMap = this.muleContext.getRegistry().lookupByType(JettyHttpConnector.class);
        if (connectorMap.isEmpty()) {
            this.unregisterMeQuietly();
        }
        for (JettyHttpConnector c : connectorMap.values()) {
            if (c.canHostFullWars()) continue;
            this.unregisterMeQuietly();
            break;
        }
    }

    public void stop() throws MuleException {
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder(String.format("'''Embedded server hosting webapps at:%n   ", new Object[0]));
        sb.append(StringUtils.join(this.webapps.iterator(), (String)String.format("%n   ", new Object[0])));
        return sb.toString();
    }

    public void onJettyConnectorStarted(JettyHttpConnector jetty) {
        Handler[] handlers;
        for (Handler handler : handlers = jetty.getHttpServer().getChildHandlersByClass(WebAppContext.class)) {
            WebAppContext webapp = (WebAppContext)handler;
            Connector c = jetty.getHttpServer().getConnectors()[0];
            String url = String.format("http://%s%s%s", c.getHost(), c.getPort() == 80 ? "" : ":" + c.getPort(), webapp.getContextPath());
            this.webapps.add(url);
        }
    }
}

