/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.keyword.PositiveIntegerKeywordValidator;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class MaxItemsKeywordValidator
extends PositiveIntegerKeywordValidator {
    public MaxItemsKeywordValidator(JsonNode schema) {
        super("maxItems", schema, NodeType.ARRAY);
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        if (instance.size() <= this.intValue) {
            return;
        }
        Message.Builder msg = this.newMsg().addInfo(this.keyword, this.intValue).addInfo("found", instance.size()).setMessage("too many elements in array");
        report.addMessage(msg.build());
    }
}

