/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.module.launcher.ArchiveDeployer;
import org.mule.module.launcher.CompositeDeploymentListener;
import org.mule.module.launcher.DeploymentException;
import org.mule.module.launcher.DeploymentService;
import org.mule.module.launcher.application.Application;
import org.mule.module.launcher.artifact.ArtifactFactory;
import org.mule.module.launcher.domain.Domain;
import org.mule.module.reboot.MuleContainerBootstrapUtils;
import org.mule.util.Preconditions;

public class DomainArchiveDeployer
implements ArchiveDeployer<Domain> {
    private final transient Log logger = LogFactory.getLog(this.getClass());
    public static final String DOMAIN_BUNDLE_APPS_FOLDER = "apps";
    private final ArchiveDeployer<Domain> domainDeployer;
    private final DeploymentService deploymentService;
    private final ArchiveDeployer<Application> applicationDeployer;

    public DomainArchiveDeployer(ArchiveDeployer<Domain> domainDeployer, ArchiveDeployer<Application> applicationDeployer, DeploymentService deploymentService) {
        this.domainDeployer = domainDeployer;
        this.applicationDeployer = applicationDeployer;
        this.deploymentService = deploymentService;
    }

    @Override
    public Domain deployPackagedArtifact(String zip) throws DeploymentException {
        Domain domain = this.domainDeployer.deployPackagedArtifact(zip);
        this.deployBundledAppsIfDomainWasCreated(domain);
        return domain;
    }

    @Override
    public Domain deployExplodedArtifact(String artifactDir) throws DeploymentException {
        Domain domain = this.domainDeployer.deployExplodedArtifact(artifactDir);
        this.deployBundledAppsIfDomainWasCreated(domain);
        return domain;
    }

    @Override
    public Domain deployPackagedArtifact(URL artifactAchivedUrl) {
        Domain domain = this.domainDeployer.deployPackagedArtifact(artifactAchivedUrl);
        this.deployBundledAppsIfDomainWasCreated(domain);
        return domain;
    }

    @Override
    public void undeployArtifact(String artifactId) {
        Domain domain = this.deploymentService.findDomain(artifactId);
        Preconditions.checkArgument((domain != null ? 1 : 0) != 0, (String)String.format("Domain %s does not exists", artifactId));
        Collection<Application> domainApplications = this.deploymentService.findDomainApplications(artifactId);
        for (Application domainApplication : domainApplications) {
            this.applicationDeployer.undeployArtifact(domainApplication.getArtifactName());
        }
        this.domainDeployer.undeployArtifact(artifactId);
    }

    @Override
    public File getDeploymentDirectory() {
        return this.domainDeployer.getDeploymentDirectory();
    }

    @Override
    public void setDeploymentListener(CompositeDeploymentListener deploymentListener) {
        this.domainDeployer.setDeploymentListener(deploymentListener);
    }

    @Override
    public void redeploy(Domain artifact) {
        this.domainDeployer.redeploy(artifact);
    }

    @Override
    public Map<URL, Long> getArtifactsZombieMap() {
        return this.domainDeployer.getArtifactsZombieMap();
    }

    @Override
    public void setArtifactFactory(ArtifactFactory<Domain> artifactFactory) {
        this.domainDeployer.setArtifactFactory(artifactFactory);
    }

    private void deployBundledAppsIfDomainWasCreated(Domain domain) {
        if (domain != null) {
            this.deployBundleApps(domain);
        }
    }

    private void deployBundleApps(Domain domain) {
        File domainFolder = new File(this.domainDeployer.getDeploymentDirectory(), domain.getArtifactName());
        File appsFolder = new File(domainFolder, DOMAIN_BUNDLE_APPS_FOLDER);
        if (appsFolder.exists()) {
            File[] files;
            for (File file : files = appsFolder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".zip");
                }
            })) {
                try {
                    FileUtils.moveFile((File)file, (File)new File(MuleContainerBootstrapUtils.getMuleAppsDir(), file.getName()));
                }
                catch (IOException e) {
                    this.logger.warn((Object)e.getMessage());
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)e);
                }
            }
        }
    }
}

