/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.mule.module.launcher.GoodCitizenClassLoader;
import org.mule.util.StringUtils;

public class FineGrainedControlClassLoader
extends GoodCitizenClassLoader {
    protected String appName;
    protected String[] systemPackages = new String[]{"java.", "javax.", "org.mule.", "com.mulesoft.", "com.mulesource."};
    protected Set<String> overrides = new HashSet<String>();
    protected Set<String> blocked = new HashSet<String>();

    public FineGrainedControlClassLoader(URL[] urls, ClassLoader parent) {
        this(urls, parent, Collections.emptySet());
    }

    public FineGrainedControlClassLoader(URL[] urls, ClassLoader parent, Set<String> overrides) {
        super(urls, parent);
        this.processOverrides(overrides);
    }

    protected void processOverrides(Set<String> overrides) {
        if (overrides != null && !overrides.isEmpty()) {
            for (String override : overrides) {
                if ((override = StringUtils.defaultString((String)override).trim()).startsWith("-")) {
                    override = override.substring(1);
                    this.blocked.add(override);
                }
                this.overrides.add(override);
                for (String systemPackage : this.systemPackages) {
                    if (!override.startsWith(systemPackage)) continue;
                    throw new IllegalArgumentException("Can't override a system package. Offending value: " + override);
                }
            }
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClass(name);
        if (result != null) {
            return result;
        }
        boolean overrideMatch = this.isOverridden(name);
        if (overrideMatch) {
            boolean blockedMatch = this.isBlocked(name);
            if (blockedMatch) {
                result = this.findClass(name);
            } else {
                try {
                    result = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    result = this.findParentClass(name);
                }
            }
        } else {
            try {
                result = this.findParentClass(name);
            }
            catch (ClassNotFoundException e) {
                result = this.findClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(result);
        }
        return result;
    }

    public boolean isOverridden(String name) {
        boolean overrideMatch = false;
        for (String override : this.overrides) {
            if (!name.equals(override) && !name.startsWith(override + ".")) continue;
            overrideMatch = true;
            break;
        }
        return overrideMatch;
    }

    public boolean isBlocked(String name) {
        boolean blockedMatch = false;
        for (String b : this.blocked) {
            if (!name.equals(b) && !name.startsWith(b + ".")) continue;
            blockedMatch = true;
            break;
        }
        return blockedMatch;
    }

    protected Class<?> findParentClass(String name) throws ClassNotFoundException {
        if (this.getParent() != null) {
            return this.getParent().loadClass(name);
        }
        return this.findSystemClass(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }
}

