/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.management.agent;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.registry.RegistrationException;
import org.mule.module.management.agent.AbstractJmxAgent;

public class JmxAgentConfigurer
implements MuleContextAware {
    public static final Map<String, Object> DEFAULT_CONNECTOR_SERVER_PROPERTIES;
    protected static final Log logger;
    protected MuleContext muleContext;
    protected boolean locateServer = true;
    private boolean createServer = false;
    private String connectorServerUrl;
    private MBeanServer mBeanServer;
    private Map<String, Object> connectorServerProperties = null;
    private boolean enableStatistics = true;
    private boolean createRmiRegistry = true;
    private Map<String, String> credentials = new HashMap<String, String>();

    public JmxAgentConfigurer() {
        this.connectorServerProperties = new HashMap<String, Object>(DEFAULT_CONNECTOR_SERVER_PROPERTIES);
    }

    public boolean isCreateServer() {
        return this.createServer;
    }

    public void setCreateServer(boolean createServer) {
        this.createServer = createServer;
    }

    public boolean isLocateServer() {
        return this.locateServer;
    }

    public void setLocateServer(boolean locateServer) {
        this.locateServer = locateServer;
    }

    public String getConnectorServerUrl() {
        return this.connectorServerUrl;
    }

    public void setConnectorServerUrl(String connectorServerUrl) {
        this.connectorServerUrl = connectorServerUrl;
    }

    public boolean isEnableStatistics() {
        return this.enableStatistics;
    }

    public void setEnableStatistics(boolean enableStatistics) {
        this.enableStatistics = enableStatistics;
    }

    public MBeanServer getMBeanServer() {
        return this.mBeanServer;
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    public Map<String, Object> getConnectorServerProperties() {
        return this.connectorServerProperties;
    }

    public void setConnectorServerProperties(Map<String, Object> connectorServerProperties) {
        this.connectorServerProperties = connectorServerProperties;
    }

    public void setCredentials(Map<String, String> newCredentials) {
        this.credentials.clear();
        if (newCredentials != null && !newCredentials.isEmpty()) {
            this.credentials.putAll(newCredentials);
        }
    }

    public boolean isCreateRmiRegistry() {
        return this.createRmiRegistry;
    }

    public void setCreateRmiRegistry(boolean createRmiRegistry) {
        this.createRmiRegistry = createRmiRegistry;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        try {
            AbstractJmxAgent agent = (AbstractJmxAgent)((Object)this.muleContext.getRegistry().lookupObject(AbstractJmxAgent.class));
            if (this.getMBeanServer() != null) {
                agent.setMBeanServer(this.getMBeanServer());
            }
            if (this.getConnectorServerUrl() != null) {
                agent.setConnectorServerUrl(this.getConnectorServerUrl());
            }
            if (this.getConnectorServerProperties() != null && !this.getConnectorServerProperties().isEmpty()) {
                agent.setConnectorServerProperties(this.getConnectorServerProperties());
            }
            agent.setCreateServer(this.isCreateServer());
            agent.setLocateServer(this.isLocateServer());
            agent.setEnableStatistics(this.isEnableStatistics());
            agent.setCreateRmiRegistry(this.isCreateRmiRegistry());
            agent.setCredentials(this.credentials);
        }
        catch (RegistrationException e) {
            throw new RuntimeException(e);
        }
    }

    public void setName(String name) {
    }

    static {
        logger = LogFactory.getLog(JmxAgentConfigurer.class);
        HashMap<String, String> props = new HashMap<String, String>(1);
        props.put("jmx.remote.jndi.rebind", "true");
        DEFAULT_CONNECTOR_SERVER_PROPERTIES = Collections.unmodifiableMap(props);
    }
}

