/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.config.domain.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.mule.module.db.internal.config.domain.param.AbstractParamDefinitionDefinitionParser;
import org.mule.module.db.internal.config.domain.param.InOutParamDefinitionDefinitionParser;
import org.mule.module.db.internal.config.domain.param.InputParamDefinitionDefinitionParser;
import org.mule.module.db.internal.config.domain.param.InputParamValueBeanDefinitionParser;
import org.mule.module.db.internal.config.domain.param.OutputParamDefinitionDefinitionParser;
import org.mule.module.db.internal.config.domain.query.QueryTemplateFactoryBean;
import org.mule.module.db.internal.domain.param.InputQueryParam;
import org.mule.module.db.internal.domain.param.QueryParam;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.domain.query.QueryParamValue;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.parser.SimpleQueryTemplateParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ParameterizedQueryDefinitionParser {
    public static final String PARAMETERIZED_QUERY = "parameterized-query";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String TEMPLATE_QUERY_REF = "template-query-ref";
    public static final String DYNAMIC_QUERY = "dynamic-query";
    public static final String[] QUERY_TAG_NAMES = new String[]{"parameterized-query", "template-query-ref", "dynamic-query"};
    public static final String IN_PARAM_TAG = "in-param";

    private BeanDefinition parseQuery(Element queryElement, List<Element> paramElements, ParserContext nestedCtx, BeanDefinition sqlParamResolver, BeanDefinition dbConfigResolver) {
        if (PARAMETERIZED_QUERY.equals(queryElement.getLocalName())) {
            return this.parseParameterizedQuery(queryElement, paramElements, nestedCtx, sqlParamResolver, dbConfigResolver);
        }
        if (TEMPLATE_QUERY_REF.equals(queryElement.getLocalName())) {
            return this.parseTemplateQueryRef(queryElement, paramElements, nestedCtx, sqlParamResolver, dbConfigResolver);
        }
        if (DYNAMIC_QUERY.equals(queryElement.getLocalName())) {
            return this.parseDynamicQuery(queryElement, paramElements, nestedCtx, sqlParamResolver, dbConfigResolver);
        }
        throw new IllegalStateException("Element must contain an element in: " + Arrays.toString(QUERY_TAG_NAMES));
    }

    private BeanDefinition parseDynamicQuery(Element queryElement, List<Element> paramElements, ParserContext nestedCtx, BeanDefinition sqlParamResolver, BeanDefinition dbConfigResolver) {
        List<BeanDefinition> paramValues = ParameterizedQueryDefinitionParser.parseParameterValues(paramElements, nestedCtx);
        String sql = queryElement.getTextContent();
        QueryTemplate queryTemplate = new QueryTemplate(sql, QueryType.DDL, Collections.<QueryParam>emptyList(), true);
        BeanDefinitionBuilder queryBuilder = BeanDefinitionBuilder.genericBeanDefinition(Query.class);
        queryBuilder.addConstructorArgValue((Object)queryTemplate);
        queryBuilder.addConstructorArgValue(paramValues);
        AbstractBeanDefinition queryBean = queryBuilder.getBeanDefinition();
        return queryBean;
    }

    private BeanDefinition parseTemplateQueryRef(Element queryElement, List<Element> paramElements, ParserContext nestedCtx, BeanDefinition sqlParamResolver, BeanDefinition dbConfigResolver) {
        String queryTemplateRef = queryElement.getAttribute(NAME_ATTRIBUTE);
        List<BeanDefinition> paramValues = ParameterizedQueryDefinitionParser.parseParameterValues(paramElements, nestedCtx);
        BeanDefinitionBuilder queryTemplateFactoryBean = BeanDefinitionBuilder.genericBeanDefinition(QueryTemplateFactoryBean.class);
        queryTemplateFactoryBean.addConstructorArgReference(queryTemplateRef);
        queryTemplateFactoryBean.addConstructorArgValue(paramValues);
        BeanDefinitionBuilder queryBuilder = BeanDefinitionBuilder.genericBeanDefinition(Query.class);
        queryBuilder.addConstructorArgValue((Object)queryTemplateFactoryBean.getBeanDefinition());
        AbstractBeanDefinition queryBean = queryBuilder.getBeanDefinition();
        return queryBean;
    }

    private BeanDefinition parseParameterizedQuery(Element queryElement, List<Element> paramElements, ParserContext nestedCtx, BeanDefinition sqlParamResolver, BeanDefinition dbConfigResolver) {
        SimpleQueryTemplateParser sqlParser = new SimpleQueryTemplateParser();
        String sql = queryElement.getTextContent();
        QueryTemplate queryTemplate = sqlParser.parse(sql);
        if (queryTemplate.getType() == QueryType.STORE_PROCEDURE_CALL) {
            List<BeanDefinition> newParams = this.parseStoreProcedureParams(paramElements, nestedCtx);
            BeanDefinitionBuilder definitionFactoryBean = BeanDefinitionBuilder.genericBeanDefinition(QueryTemplate.class);
            definitionFactoryBean.addConstructorArgValue((Object)queryTemplate.getSqlText());
            definitionFactoryBean.addConstructorArgValue((Object)queryTemplate.getType());
            definitionFactoryBean.addConstructorArgValue(newParams);
            BeanDefinitionBuilder queryBuilder = BeanDefinitionBuilder.genericBeanDefinition(Query.class);
            queryBuilder.addConstructorArgValue((Object)definitionFactoryBean.getBeanDefinition());
            AbstractBeanDefinition queryBean = queryBuilder.getBeanDefinition();
            return queryBean;
        }
        List<BeanDefinition> params = ParameterizedQueryDefinitionParser.parseParameterValues(paramElements, nestedCtx);
        BeanDefinitionBuilder queryBuilder = BeanDefinitionBuilder.genericBeanDefinition(Query.class);
        queryBuilder.addConstructorArgValue((Object)queryTemplate);
        if (params.size() == 0 && !queryTemplate.getParams().isEmpty()) {
            ArrayList<QueryParamValue> paramValues = new ArrayList<QueryParamValue>();
            for (InputQueryParam inputSqlParam : queryTemplate.getInputParams()) {
                QueryParamValue paramValue = new QueryParamValue(inputSqlParam.getName(), inputSqlParam.getValue());
                paramValues.add(paramValue);
            }
            queryBuilder.addConstructorArgValue(paramValues);
        } else {
            queryBuilder.addConstructorArgValue(params);
        }
        AbstractBeanDefinition queryBean = queryBuilder.getBeanDefinition();
        return queryBean;
    }

    private List<BeanDefinition> parseStoreProcedureParams(List<Element> paramElements, ParserContext nestedCtx) {
        ManagedList params = new ManagedList();
        for (Element param : paramElements) {
            AbstractParamDefinitionDefinitionParser paramParser;
            if (IN_PARAM_TAG.equals(param.getLocalName())) {
                paramParser = new InputParamDefinitionDefinitionParser();
            } else if ("out-param".equals(param.getLocalName())) {
                paramParser = new OutputParamDefinitionDefinitionParser();
            } else if ("inout-param".equals(param.getLocalName())) {
                paramParser = new InOutParamDefinitionDefinitionParser();
            } else {
                throw new IllegalStateException("Unsupported param type: " + param.getLocalName());
            }
            BeanDefinition paramBean = paramParser.parse(param, nestedCtx);
            params.add(paramBean);
        }
        return params;
    }

    public static List<BeanDefinition> parseParameterValues(List<Element> paramElements, ParserContext nestedCtx) {
        ManagedList params = new ManagedList();
        for (Element param : paramElements) {
            if (!IN_PARAM_TAG.equals(param.getLocalName())) {
                throw new IllegalStateException("Unsupported param type: " + param.getLocalName());
            }
            InputParamValueBeanDefinitionParser paramParser = new InputParamValueBeanDefinitionParser();
            BeanDefinition paramBean = paramParser.parse(param, nestedCtx);
            params.add(paramBean);
        }
        return params;
    }

    public BeanDefinition parseQuery(Element element, ParserContext nestedCtx, BeanDefinition sqlParamResolver, BeanDefinition dbConfigResolver) {
        List childElementsByTagName = DomUtils.getChildElementsByTagName((Element)element, (String[])QUERY_TAG_NAMES);
        if (childElementsByTagName.size() == 0) {
            throw new IllegalArgumentException(String.format("Element %s must contain one of the following elements: %s", element.getTagName(), Arrays.toString(QUERY_TAG_NAMES)));
        }
        List params = DomUtils.getChildElementsByTagName((Element)element, (String[])new String[]{IN_PARAM_TAG, "out-param", "inout-param"});
        Element queryElement = (Element)childElementsByTagName.get(0);
        element.removeChild(queryElement);
        return this.parseQuery(queryElement, params, nestedCtx, sqlParamResolver, dbConfigResolver);
    }
}

