/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.resolver.database;

import java.util.Collection;
import org.mule.api.MuleEvent;
import org.mule.api.registry.MuleRegistry;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;
import org.mule.module.db.internal.resolver.database.UnresolvableDbConfigException;

public class DefaultDbConfigResolver
implements DbConfigResolver {
    private final MuleRegistry registry;
    private DbConfig defaultConfig;

    public DefaultDbConfigResolver(MuleRegistry registry) {
        this.registry = registry;
    }

    private DbConfig getDefaultConfig() {
        Collection dbConfigs = this.registry.lookupObjects(DbConfig.class);
        if (dbConfigs.size() == 0) {
            throw new UnresolvableDbConfigException("There is no database config defined");
        }
        if (dbConfigs.size() > 1) {
            StringBuilder stringBuilder = new StringBuilder();
            for (DbConfig dbConfig : dbConfigs) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(dbConfig.getName());
            }
            throw new UnresolvableDbConfigException("Database config must be explicitly defined using 'config-ref' attribute there are multiple database configs defined: " + stringBuilder);
        }
        return (DbConfig)dbConfigs.iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbConfig resolve(MuleEvent muleEvent) {
        if (this.defaultConfig == null) {
            DefaultDbConfigResolver defaultDbConfigResolver = this;
            synchronized (defaultDbConfigResolver) {
                if (this.defaultConfig == null) {
                    this.defaultConfig = this.getDefaultConfig();
                }
            }
        }
        return this.defaultConfig;
    }
}

