/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exception;

import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleRuntimeException;
import org.mule.api.exception.MessagingExceptionHandlerAcceptor;
import org.mule.exception.ChoiceMessagingExceptionStrategy;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class ChoiceMessagingExceptionStrategyTestCase
extends AbstractMuleTestCase {
    @Mock
    private MessagingExceptionHandlerAcceptor mockTestExceptionStrategy1;
    @Mock
    private MessagingExceptionHandlerAcceptor mockTestExceptionStrategy2;
    @Mock
    private MessagingExceptionHandlerAcceptor mockDefaultTestExceptionStrategy2;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleEvent mockMuleEvent;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleContext mockMuleContext;
    private Exception mockException = new Exception();

    @Test
    public void testNonMatchThenCallDefault() throws Exception {
        ChoiceMessagingExceptionStrategy choiceMessagingExceptionStrategy = new ChoiceMessagingExceptionStrategy();
        Mockito.when((Object)this.mockMuleContext.getDefaultExceptionStrategy()).thenReturn((Object)this.mockDefaultTestExceptionStrategy2);
        choiceMessagingExceptionStrategy.setMuleContext(this.mockMuleContext);
        choiceMessagingExceptionStrategy.setExceptionListeners(new ArrayList<MessagingExceptionHandlerAcceptor>(Arrays.asList(this.mockTestExceptionStrategy1, this.mockTestExceptionStrategy2)));
        choiceMessagingExceptionStrategy.initialise();
        Mockito.when((Object)this.mockTestExceptionStrategy1.accept(this.mockMuleEvent)).thenReturn((Object)false);
        Mockito.when((Object)this.mockTestExceptionStrategy2.accept(this.mockMuleEvent)).thenReturn((Object)false);
        Mockito.when((Object)this.mockDefaultTestExceptionStrategy2.accept(this.mockMuleEvent)).thenReturn((Object)true);
        choiceMessagingExceptionStrategy.handleException(this.mockException, this.mockMuleEvent);
        ((MessagingExceptionHandlerAcceptor)Mockito.verify((Object)this.mockTestExceptionStrategy1, (VerificationMode)VerificationModeFactory.times((int)0))).handleException((Exception)Matchers.any(Exception.class), (MuleEvent)Matchers.any(MuleEvent.class));
        ((MessagingExceptionHandlerAcceptor)Mockito.verify((Object)this.mockTestExceptionStrategy2, (VerificationMode)VerificationModeFactory.times((int)0))).handleException((Exception)Matchers.any(Exception.class), (MuleEvent)Matchers.any(MuleEvent.class));
        ((MessagingExceptionHandlerAcceptor)Mockito.verify((Object)this.mockDefaultTestExceptionStrategy2, (VerificationMode)VerificationModeFactory.times((int)1))).handleException(this.mockException, this.mockMuleEvent);
    }

    @Test
    public void testSecondMatches() throws Exception {
        ChoiceMessagingExceptionStrategy choiceMessagingExceptionStrategy = new ChoiceMessagingExceptionStrategy();
        choiceMessagingExceptionStrategy.setMuleContext(this.mockMuleContext);
        choiceMessagingExceptionStrategy.setExceptionListeners(new ArrayList<MessagingExceptionHandlerAcceptor>(Arrays.asList(this.mockTestExceptionStrategy1, this.mockTestExceptionStrategy2)));
        Mockito.when((Object)this.mockMuleContext.getDefaultExceptionStrategy()).thenReturn((Object)this.mockDefaultTestExceptionStrategy2);
        choiceMessagingExceptionStrategy.initialise();
        Mockito.when((Object)this.mockTestExceptionStrategy1.accept(this.mockMuleEvent)).thenReturn((Object)false);
        Mockito.when((Object)this.mockTestExceptionStrategy2.accept(this.mockMuleEvent)).thenReturn((Object)true);
        Mockito.when((Object)this.mockDefaultTestExceptionStrategy2.accept(this.mockMuleEvent)).thenReturn((Object)true);
        choiceMessagingExceptionStrategy.handleException(this.mockException, this.mockMuleEvent);
        ((MessagingExceptionHandlerAcceptor)Mockito.verify((Object)this.mockTestExceptionStrategy1, (VerificationMode)VerificationModeFactory.times((int)0))).handleException((Exception)Matchers.any(Exception.class), (MuleEvent)Matchers.any(MuleEvent.class));
        ((MessagingExceptionHandlerAcceptor)Mockito.verify((Object)this.mockDefaultTestExceptionStrategy2, (VerificationMode)VerificationModeFactory.times((int)0))).handleException((Exception)Matchers.any(Exception.class), (MuleEvent)Matchers.any(MuleEvent.class));
        ((MessagingExceptionHandlerAcceptor)Mockito.verify((Object)this.mockTestExceptionStrategy2, (VerificationMode)VerificationModeFactory.times((int)1))).handleException(this.mockException, this.mockMuleEvent);
    }

    @Test(expected=MuleRuntimeException.class)
    public void testFirstAcceptsAllMatches() throws Exception {
        ChoiceMessagingExceptionStrategy choiceMessagingExceptionStrategy = new ChoiceMessagingExceptionStrategy();
        choiceMessagingExceptionStrategy.setMuleContext(this.mockMuleContext);
        choiceMessagingExceptionStrategy.setExceptionListeners(new ArrayList<MessagingExceptionHandlerAcceptor>(Arrays.asList(this.mockTestExceptionStrategy1, this.mockTestExceptionStrategy2)));
        Mockito.when((Object)this.mockMuleContext.getDefaultExceptionStrategy()).thenReturn((Object)this.mockDefaultTestExceptionStrategy2);
        Mockito.when((Object)this.mockTestExceptionStrategy1.acceptsAll()).thenReturn((Object)true);
        Mockito.when((Object)this.mockTestExceptionStrategy2.acceptsAll()).thenReturn((Object)false);
        Mockito.when((Object)this.mockDefaultTestExceptionStrategy2.acceptsAll()).thenReturn((Object)true);
        choiceMessagingExceptionStrategy.initialise();
    }
}

