/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import java.io.ByteArrayInputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.routing.filters.ConsumableMuleMessageFilter;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ConsumableFilterTestCase
extends AbstractMuleTestCase {
    private ConsumableMuleMessageFilter filter;

    @Before
    public void setUp() throws Exception {
        this.filter = new ConsumableMuleMessageFilter();
    }

    @Test
    public void testRejectsNonDefaultMuleMessageInstances() throws Exception {
        MuleMessage message = (MuleMessage)Mockito.mock(MuleMessage.class);
        Assert.assertFalse((String)"Should reject non DefaultMuleMessage instances", (boolean)this.filter.accept(message));
    }

    @Test
    public void testRejectsConsumablePayload() throws Exception {
        MuleContext context = (MuleContext)Mockito.mock(MuleContext.class);
        ByteArrayInputStream is = new ByteArrayInputStream("TEST".getBytes());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)is, context);
        Assert.assertFalse((String)"Should reject consumable payload", (boolean)this.filter.accept((MuleMessage)message));
    }

    @Test
    public void testAcceptsNonConsumablePayload() throws Exception {
        MuleContext context = (MuleContext)Mockito.mock(MuleContext.class);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"TEST", context);
        Assert.assertTrue((String)"Should accept non consumable payload", (boolean)this.filter.accept((MuleMessage)message));
    }
}

