/*
 * Decompiled with CFR 0.152.
 */
package org.mule.source;

import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleContext;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.source.ClusterizableMessageSource;
import org.mule.context.notification.ClusterNodeNotification;
import org.mule.lifecycle.PrimaryNodeLifecycleNotificationListener;
import org.mule.source.ClusterizableMessageSourceWrapper;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ClusterizableMessageSourceWrapperTestCase
extends AbstractMuleTestCase {
    private TestMessageSource messageSource = (TestMessageSource)Mockito.mock(TestMessageSource.class);
    private ClusterizableMessageSourceWrapper wrapper = new ClusterizableMessageSourceWrapper((ClusterizableMessageSource)this.messageSource);
    private MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);

    @Test
    public void delegatesSetListener() {
        MessageProcessor listener = (MessageProcessor)Mockito.mock(MessageProcessor.class);
        this.wrapper.setListener(listener);
        ((TestMessageSource)Mockito.verify((Object)this.messageSource, (VerificationMode)Mockito.times((int)1))).setListener(listener);
    }

    @Test
    public void delegatesDispose() throws Exception {
        this.wrapper.setMuleContext(this.muleContext);
        this.wrapper.initialise();
        this.wrapper.dispose();
        ((TestMessageSource)Mockito.verify((Object)this.messageSource, (VerificationMode)Mockito.times((int)1))).dispose();
    }

    @Test
    public void delegatesInitialise() throws Exception {
        this.wrapper.initialise();
        ((TestMessageSource)Mockito.verify((Object)this.messageSource, (VerificationMode)Mockito.times((int)1))).initialise();
    }

    @Test
    public void ignoresStopIfNoStarted() throws Exception {
        this.wrapper.stop();
        ((TestMessageSource)Mockito.verify((Object)this.messageSource, (VerificationMode)Mockito.times((int)0))).stop();
    }

    @Test
    public void delegatesStop() throws Exception {
        Mockito.when((Object)this.muleContext.isPrimaryPollingInstance()).thenReturn((Object)true);
        this.wrapper.setMuleContext(this.muleContext);
        this.wrapper.start();
        this.wrapper.stop();
        ((TestMessageSource)Mockito.verify((Object)this.messageSource, (VerificationMode)Mockito.times((int)1))).stop();
    }

    @Test
    public void registerNotificationListenerOnInitialization() throws Exception {
        this.wrapper.setMuleContext(this.muleContext);
        this.wrapper.initialise();
        ((MuleContext)Mockito.verify((Object)this.muleContext, (VerificationMode)Mockito.times((int)1))).registerListener((ServerNotificationListener)Mockito.any(PrimaryNodeLifecycleNotificationListener.class));
    }

    @Test
    public void startsWhenIsPrimaryNode() throws Exception {
        Mockito.when((Object)this.muleContext.isPrimaryPollingInstance()).thenReturn((Object)true);
        this.wrapper.setMuleContext(this.muleContext);
        this.wrapper.start();
        ((TestMessageSource)Mockito.verify((Object)this.messageSource, (VerificationMode)Mockito.times((int)1))).start();
    }

    @Test
    public void ignoresStartWhenIsSecondaryNode() throws Exception {
        Mockito.when((Object)this.muleContext.isPrimaryPollingInstance()).thenReturn((Object)false);
        this.wrapper.setMuleContext(this.muleContext);
        this.wrapper.start();
        ((TestMessageSource)Mockito.verify((Object)this.messageSource, (VerificationMode)Mockito.times((int)0))).start();
    }

    @Test
    public void ignoresMessageSourceOnNotificationIfFlowIsStopped() throws Exception {
        Mockito.when((Object)this.muleContext.isPrimaryPollingInstance()).thenReturn((Object)true);
        this.wrapper.setMuleContext(this.muleContext);
        ((MuleContext)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                ((PrimaryNodeLifecycleNotificationListener)invocationOnMock.getArguments()[0]).onNotification((ServerNotification)new ClusterNodeNotification((Object)"", 1));
                return null;
            }
        }).when((Object)this.muleContext)).registerListener((ServerNotificationListener)Matchers.isA(PrimaryNodeLifecycleNotificationListener.class));
        this.wrapper.initialise();
        ((TestMessageSource)Mockito.verify((Object)this.messageSource, (VerificationMode)Mockito.times((int)0))).start();
    }

    @Test
    public void startsMessageSourceOnNotificationIfMessageSourceIsStarted() throws Exception {
        Mockito.when((Object)this.muleContext.isPrimaryPollingInstance()).thenReturn((Object)false);
        this.wrapper.setMuleContext(this.muleContext);
        final PrimaryNodeLifecycleNotificationListener[] primaryNodeLifecycleNotificationListener = new PrimaryNodeLifecycleNotificationListener[1];
        ((MuleContext)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                primaryNodeLifecycleNotificationListener[0] = (PrimaryNodeLifecycleNotificationListener)invocationOnMock.getArguments()[0];
                return null;
            }
        }).when((Object)this.muleContext)).registerListener((ServerNotificationListener)Matchers.isA(PrimaryNodeLifecycleNotificationListener.class));
        this.wrapper.initialise();
        this.wrapper.start();
        Mockito.when((Object)this.muleContext.isPrimaryPollingInstance()).thenReturn((Object)true);
        primaryNodeLifecycleNotificationListener[0].onNotification((ServerNotification)new ClusterNodeNotification((Object)"", 1));
        ((TestMessageSource)Mockito.verify((Object)this.messageSource, (VerificationMode)Mockito.times((int)1))).start();
    }

    @Test
    public void ignoresStartWhenWrappedMessageSourceIsAlreadyStarted() throws Exception {
        Mockito.when((Object)this.muleContext.isPrimaryPollingInstance()).thenReturn((Object)true);
        this.wrapper.setMuleContext(this.muleContext);
        this.wrapper.start();
        this.wrapper.start();
        ((TestMessageSource)Mockito.verify((Object)this.messageSource, (VerificationMode)Mockito.times((int)1))).start();
    }

    @Test
    public void unregistersListenerOnDispose() throws Exception {
        this.wrapper.setMuleContext(this.muleContext);
        this.wrapper.initialise();
        this.wrapper.dispose();
        ((MuleContext)Mockito.verify((Object)this.muleContext, (VerificationMode)Mockito.times((int)1))).unregisterListener((ServerNotificationListener)Matchers.isA(PrimaryNodeLifecycleNotificationListener.class));
    }

    private static interface TestMessageSource
    extends ClusterizableMessageSource,
    Lifecycle {
    }
}

