/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.util.Collections;
import java.util.List;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.context.WorkManager;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.size.SmallTest;
import org.mule.transport.TrackingWorkManager;
import org.mule.transport.WorkListenerWrapperFactory;
import org.mule.transport.WorkManagerHolder;
import org.mule.transport.WorkTracker;

@SmallTest
public class TrackingWorkManagerTestCase
extends AbstractMuleTestCase {
    @Rule
    public SystemProperty waitMillis = new SystemProperty("mule.transport.dispose.wait", "0");
    private final WorkManager delegateWorkManager = (WorkManager)Mockito.mock(WorkManager.class);
    private final WorkTracker workTracker = (WorkTracker)Mockito.mock(WorkTracker.class);
    private final WorkManagerHolder workManagerHolder = (WorkManagerHolder)Mockito.mock(WorkManagerHolder.class);
    private TrackingWorkManager trackingWorkManager;

    @Before
    public void setUp() throws Exception {
        this.trackingWorkManager = new TrackingWorkManager(this.workManagerHolder, 5000);
        this.trackingWorkManager.setWorkTracker(this.workTracker);
        Mockito.when((Object)this.workManagerHolder.getWorkManager()).thenReturn((Object)this.delegateWorkManager);
    }

    @Test
    public void delegatesDoWork() throws WorkException {
        final Work work = (Work)Mockito.mock(Work.class);
        ((WorkManager)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                work.run();
                return null;
            }
        }).when((Object)this.delegateWorkManager)).doWork(work);
        this.trackingWorkManager.doWork(work);
        ((Work)Mockito.verify((Object)work)).run();
    }

    @Test
    public void tracksWorkOnDoWorkDelegation() throws Exception {
        Work work = (Work)Mockito.mock(Work.class);
        this.trackingWorkManager.doWork(work);
        this.assertWorkIsTracked(work);
    }

    @Test
    public void untracksWorkOnDoWorkException() throws Exception {
        Work work = (Work)Mockito.mock(Work.class);
        ((WorkManager)Mockito.doThrow((Throwable)new WorkException()).when((Object)this.delegateWorkManager)).doWork(work);
        try {
            this.trackingWorkManager.doWork(work);
            this.expectedExceptionFail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertWorkIsTracked(work);
    }

    @Test
    public void delegatesParameterizedDoWork() throws WorkException {
        Work work = (Work)Mockito.mock(Work.class);
        int startTimeout = 10;
        ExecutionContext execContext = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        WorkListener workListener = (WorkListener)Mockito.mock(WorkListener.class);
        this.trackingWorkManager.doWork(work, (long)startTimeout, execContext, workListener);
        ((WorkManager)Mockito.verify((Object)this.delegateWorkManager)).doWork(work, (long)startTimeout, execContext, workListener);
    }

    @Test
    public void tracksWorkOnDoParameterizedWorkDelegation() throws Exception {
        Work work = (Work)Mockito.mock(Work.class);
        int startTimeout = 10;
        ExecutionContext execContext = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        WorkListener workListener = (WorkListener)Mockito.mock(WorkListener.class);
        this.trackingWorkManager.doWork(work, (long)startTimeout, execContext, workListener);
        this.assertParameterizedWorkWasTracked(work, startTimeout, execContext, workListener);
    }

    @Test
    public void untracksWorkOnDoParameterizedWorkException() throws Exception {
        Work work = (Work)Mockito.mock(Work.class);
        int startTimeout = 10;
        ExecutionContext execContext = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        WorkListener workListener = (WorkListener)Mockito.mock(WorkListener.class);
        ((WorkManager)Mockito.doThrow((Throwable)new WorkException()).when((Object)this.delegateWorkManager)).doWork(work, (long)startTimeout, execContext, workListener);
        try {
            this.trackingWorkManager.doWork(work, (long)startTimeout, execContext, workListener);
            this.expectedExceptionFail();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.assertParameterizedWorkWasTracked(work, startTimeout, execContext, workListener);
    }

    @Test
    public void startsWork() throws WorkException {
        final Work work = (Work)Mockito.mock(Work.class);
        ((WorkManager)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                work.run();
                return null;
            }
        }).when((Object)this.delegateWorkManager)).startWork((Work)Matchers.any());
        this.trackingWorkManager.startWork(work);
        ((Work)Mockito.verify((Object)work)).run();
    }

    @Test
    public void tracksWorkStart() throws Exception {
        Work work = (Work)Mockito.mock(Work.class);
        final ArgumentCaptor argument = ArgumentCaptor.forClass(Work.class);
        ((WorkManager)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((Work)argument.getValue()).run();
                return null;
            }
        }).when((Object)this.delegateWorkManager)).startWork((Work)argument.capture());
        this.trackingWorkManager.startWork(work);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.workTracker, this.delegateWorkManager});
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).addWork((Runnable)work);
        ((WorkManager)inOrder.verify((Object)this.delegateWorkManager)).startWork((Work)Matchers.any());
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).removeWork((Runnable)work);
    }

    @Test
    public void untracksWorkOnStartWorkException() throws Exception {
        Work work = (Work)Mockito.mock(Work.class);
        ((WorkManager)Mockito.doThrow((Throwable)new WorkException()).when((Object)this.delegateWorkManager)).startWork((Work)Matchers.any());
        try {
            this.trackingWorkManager.startWork(work);
            this.expectedExceptionFail();
        }
        catch (Exception e) {
            // empty catch block
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.workTracker, this.delegateWorkManager});
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).addWork((Runnable)work);
        ((WorkManager)inOrder.verify((Object)this.delegateWorkManager)).startWork((Work)Matchers.any());
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).removeWork((Runnable)work);
    }

    @Test
    public void untracksWorkOnStartRuntimeException() throws Exception {
        Work work = (Work)Mockito.mock(Work.class);
        ((WorkManager)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)this.delegateWorkManager)).startWork((Work)Matchers.any());
        try {
            this.trackingWorkManager.startWork(work);
            this.expectedExceptionFail();
        }
        catch (Exception e) {
            // empty catch block
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.workTracker, this.delegateWorkManager});
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).addWork((Runnable)work);
        ((WorkManager)inOrder.verify((Object)this.delegateWorkManager)).startWork((Work)Matchers.any());
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).removeWork((Runnable)work);
    }

    @Test
    public void untracksWorkOnStartExecutionException() throws Exception {
        Work work = (Work)Mockito.mock(Work.class);
        ((Work)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)work)).run();
        final ArgumentCaptor argument = ArgumentCaptor.forClass(Work.class);
        ((WorkManager)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Thread schedulerThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ((Work)argument.getValue()).run();
                    }
                });
                schedulerThread.start();
                return null;
            }
        }).when((Object)this.delegateWorkManager)).startWork((Work)argument.capture());
        this.trackingWorkManager.startWork(work);
        ((Work)Mockito.verify((Object)work, (VerificationMode)Mockito.timeout((int)5000))).run();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.workTracker, this.delegateWorkManager});
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).addWork((Runnable)work);
        ((WorkManager)inOrder.verify((Object)this.delegateWorkManager)).startWork((Work)Matchers.any());
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).removeWork((Runnable)work);
    }

    @Test
    public void startsParameterizedWork() throws WorkException {
        final Work work = (Work)Mockito.mock(Work.class);
        long startTimeout = 0L;
        ExecutionContext execContext = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        WorkListener workListener = (WorkListener)Mockito.mock(WorkListener.class);
        ((WorkManager)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                work.run();
                return null;
            }
        }).when((Object)this.delegateWorkManager)).startWork((Work)Matchers.any(), Matchers.eq((long)startTimeout), (ExecutionContext)Matchers.eq((Object)execContext), (WorkListener)Matchers.any());
        this.trackingWorkManager.startWork(work, startTimeout, execContext, workListener);
        ((Work)Mockito.verify((Object)work)).run();
    }

    @Test
    public void wrapsWorkListenerOnParameterizedStartWork() throws WorkException {
        Work work = (Work)Mockito.mock(Work.class);
        long startTimeout = 0L;
        ExecutionContext execContext = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        WorkListener workListener = (WorkListener)Mockito.mock(WorkListener.class);
        WorkListener wrappedWorkListener = (WorkListener)Mockito.mock(WorkListener.class);
        WorkListenerWrapperFactory workListenerWrapperFactory = (WorkListenerWrapperFactory)Mockito.mock(WorkListenerWrapperFactory.class);
        Mockito.when((Object)workListenerWrapperFactory.create(work, workListener)).thenReturn((Object)wrappedWorkListener);
        this.trackingWorkManager.setWorkListenerWrapperFactory(workListenerWrapperFactory);
        this.trackingWorkManager.startWork(work, startTimeout, execContext, workListener);
        ((WorkListenerWrapperFactory)Mockito.verify((Object)workListenerWrapperFactory)).create(work, workListener);
        ((WorkManager)Mockito.verify((Object)this.delegateWorkManager)).startWork((Work)Matchers.any(Work.class), Matchers.eq((long)startTimeout), (ExecutionContext)Matchers.eq((Object)execContext), (WorkListener)Matchers.eq((Object)wrappedWorkListener));
    }

    @Test
    public void tracksParameterizedWorkStart() throws Exception {
        Work work = (Work)Mockito.mock(Work.class);
        long startTimeout = 0L;
        ExecutionContext execContext = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        WorkListener workListener = (WorkListener)Mockito.mock(WorkListener.class);
        final ArgumentCaptor argument = ArgumentCaptor.forClass(Work.class);
        ((WorkManager)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((Work)argument.getValue()).run();
                return null;
            }
        }).when((Object)this.delegateWorkManager)).startWork((Work)argument.capture(), Matchers.eq((long)startTimeout), (ExecutionContext)Matchers.eq((Object)execContext), (WorkListener)Matchers.any());
        this.trackingWorkManager.startWork(work, startTimeout, execContext, workListener);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.workTracker, this.delegateWorkManager});
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).addWork((Runnable)work);
        ((WorkManager)inOrder.verify((Object)this.delegateWorkManager)).startWork((Work)argument.capture(), Matchers.eq((long)startTimeout), (ExecutionContext)Matchers.eq((Object)execContext), (WorkListener)Matchers.any());
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).removeWork((Runnable)work);
    }

    @Test
    public void untracksWorkOnParameterizedStartWorkException() throws Exception {
        Work work = (Work)Mockito.mock(Work.class);
        long startTimeout = 0L;
        ExecutionContext execContext = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        WorkListener workListener = (WorkListener)Mockito.mock(WorkListener.class);
        ((WorkManager)Mockito.doThrow((Throwable)new WorkException()).when((Object)this.delegateWorkManager)).startWork((Work)Matchers.any(), Matchers.eq((long)startTimeout), (ExecutionContext)Matchers.eq((Object)execContext), (WorkListener)Matchers.any());
        try {
            this.trackingWorkManager.startWork(work, startTimeout, execContext, workListener);
            this.expectedExceptionFail();
        }
        catch (Exception e) {
            // empty catch block
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.workTracker, this.delegateWorkManager});
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).addWork((Runnable)work);
        ((WorkManager)inOrder.verify((Object)this.delegateWorkManager)).startWork((Work)Matchers.any(), Matchers.eq((long)startTimeout), (ExecutionContext)Matchers.eq((Object)execContext), (WorkListener)Matchers.any());
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).removeWork((Runnable)work);
    }

    @Test
    public void untracksWorkOnParameterizedStartRuntimeException() throws Exception {
        Work work = (Work)Mockito.mock(Work.class);
        long startTimeout = 0L;
        ExecutionContext execContext = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        WorkListener workListener = (WorkListener)Mockito.mock(WorkListener.class);
        ((WorkManager)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)this.delegateWorkManager)).startWork((Work)Matchers.any(), Matchers.eq((long)startTimeout), (ExecutionContext)Matchers.eq((Object)execContext), (WorkListener)Matchers.any());
        try {
            this.trackingWorkManager.startWork(work, startTimeout, execContext, workListener);
            this.expectedExceptionFail();
        }
        catch (Exception e) {
            // empty catch block
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.workTracker, this.delegateWorkManager});
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).addWork((Runnable)work);
        ((WorkManager)inOrder.verify((Object)this.delegateWorkManager)).startWork((Work)Matchers.any(), Matchers.eq((long)startTimeout), (ExecutionContext)Matchers.eq((Object)execContext), (WorkListener)Matchers.any());
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).removeWork((Runnable)work);
    }

    @Test
    public void untracksWorkOnParameterizedStartExecutionException() throws Exception {
        Work work = (Work)Mockito.mock(Work.class);
        long startTimeout = 0L;
        ExecutionContext execContext = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        WorkListener workListener = (WorkListener)Mockito.mock(WorkListener.class);
        ((Work)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)work)).run();
        final ArgumentCaptor argument = ArgumentCaptor.forClass(Work.class);
        ((WorkManager)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Thread schedulerThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ((Work)argument.getValue()).run();
                    }
                });
                schedulerThread.start();
                return null;
            }
        }).when((Object)this.delegateWorkManager)).startWork((Work)argument.capture(), Matchers.eq((long)startTimeout), (ExecutionContext)Matchers.eq((Object)execContext), (WorkListener)Matchers.any());
        this.trackingWorkManager.startWork(work, startTimeout, execContext, workListener);
        ((Work)Mockito.verify((Object)work, (VerificationMode)Mockito.timeout((int)5000))).run();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.workTracker, this.delegateWorkManager});
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).addWork((Runnable)work);
        ((WorkManager)inOrder.verify((Object)this.delegateWorkManager)).startWork((Work)argument.capture(), Matchers.eq((long)startTimeout), (ExecutionContext)Matchers.eq((Object)execContext), (WorkListener)Matchers.any());
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).removeWork((Runnable)work);
    }

    @Test
    public void schedulesWork() throws WorkException {
        final Work work = (Work)Mockito.mock(Work.class);
        ((WorkManager)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                work.run();
                return null;
            }
        }).when((Object)this.delegateWorkManager)).scheduleWork((Work)Matchers.any());
        this.trackingWorkManager.scheduleWork(work);
        ((Work)Mockito.verify((Object)work)).run();
    }

    @Test
    public void tracksWorkScheduling() throws Exception {
        Work work = (Work)Mockito.mock(Work.class);
        final ArgumentCaptor argument = ArgumentCaptor.forClass(Work.class);
        ((WorkManager)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((Work)argument.getValue()).run();
                return null;
            }
        }).when((Object)this.delegateWorkManager)).scheduleWork((Work)argument.capture());
        this.trackingWorkManager.scheduleWork(work);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.workTracker, this.delegateWorkManager});
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).addWork((Runnable)work);
        ((WorkManager)inOrder.verify((Object)this.delegateWorkManager)).scheduleWork((Work)Matchers.any());
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).removeWork((Runnable)work);
    }

    @Test
    public void untracksWorkOnSchedulingWorkException() throws Exception {
        Work work = (Work)Mockito.mock(Work.class);
        ((WorkManager)Mockito.doThrow((Throwable)new WorkException()).when((Object)this.delegateWorkManager)).scheduleWork((Work)Matchers.any());
        try {
            this.trackingWorkManager.scheduleWork(work);
            this.expectedExceptionFail();
        }
        catch (Exception e) {
            // empty catch block
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.workTracker, this.delegateWorkManager});
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).addWork((Runnable)work);
        ((WorkManager)inOrder.verify((Object)this.delegateWorkManager)).scheduleWork((Work)Matchers.any());
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).removeWork((Runnable)work);
    }

    @Test
    public void untracksWorkOnSchedulingRuntimeException() throws Exception {
        Work work = (Work)Mockito.mock(Work.class);
        ((WorkManager)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)this.delegateWorkManager)).scheduleWork((Work)Matchers.any());
        try {
            this.trackingWorkManager.scheduleWork(work);
            this.expectedExceptionFail();
        }
        catch (Exception e) {
            // empty catch block
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.workTracker, this.delegateWorkManager});
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).addWork((Runnable)work);
        ((WorkManager)inOrder.verify((Object)this.delegateWorkManager)).scheduleWork((Work)Matchers.any());
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).removeWork((Runnable)work);
    }

    @Test
    public void untracksWorkOnSchedulingExecutionException() throws Exception {
        Work work = (Work)Mockito.mock(Work.class);
        ((Work)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)work)).run();
        final ArgumentCaptor argument = ArgumentCaptor.forClass(Work.class);
        ((WorkManager)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Thread schedulerThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ((Work)argument.getValue()).run();
                    }
                });
                schedulerThread.start();
                return null;
            }
        }).when((Object)this.delegateWorkManager)).scheduleWork((Work)argument.capture());
        this.trackingWorkManager.scheduleWork(work);
        ((Work)Mockito.verify((Object)work, (VerificationMode)Mockito.timeout((int)5000))).run();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.workTracker, this.delegateWorkManager});
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).addWork((Runnable)work);
        ((WorkManager)inOrder.verify((Object)this.delegateWorkManager)).scheduleWork((Work)Matchers.any());
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).removeWork((Runnable)work);
    }

    @Test
    public void schedulesParameterizedWork() throws WorkException {
        Work work = (Work)Mockito.mock(Work.class);
        long startTimeout = 0L;
        ExecutionContext execContext = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        WorkListener workListener = (WorkListener)Mockito.mock(WorkListener.class);
        final ArgumentCaptor argument = ArgumentCaptor.forClass(Work.class);
        ((WorkManager)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((Work)argument.getValue()).run();
                return null;
            }
        }).when((Object)this.delegateWorkManager)).scheduleWork((Work)argument.capture(), Matchers.eq((long)startTimeout), (ExecutionContext)Matchers.eq((Object)execContext), (WorkListener)Matchers.any());
        this.trackingWorkManager.scheduleWork(work, startTimeout, execContext, workListener);
        ((Work)Mockito.verify((Object)work)).run();
    }

    @Test
    public void wrapsWorkListenerOnParameterizedScheduleWork() throws WorkException {
        Work work = (Work)Mockito.mock(Work.class);
        long startTimeout = 0L;
        ExecutionContext execContext = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        WorkListener workListener = (WorkListener)Mockito.mock(WorkListener.class);
        WorkListener wrappedWorkListener = (WorkListener)Mockito.mock(WorkListener.class);
        WorkListenerWrapperFactory workListenerWrapperFactory = (WorkListenerWrapperFactory)Mockito.mock(WorkListenerWrapperFactory.class);
        Mockito.when((Object)workListenerWrapperFactory.create(work, workListener)).thenReturn((Object)wrappedWorkListener);
        this.trackingWorkManager.setWorkListenerWrapperFactory(workListenerWrapperFactory);
        this.trackingWorkManager.scheduleWork(work, startTimeout, execContext, workListener);
        ((WorkListenerWrapperFactory)Mockito.verify((Object)workListenerWrapperFactory)).create(work, workListener);
        ((WorkManager)Mockito.verify((Object)this.delegateWorkManager)).scheduleWork((Work)Matchers.any(Work.class), Matchers.eq((long)startTimeout), (ExecutionContext)Matchers.eq((Object)execContext), (WorkListener)Matchers.eq((Object)wrappedWorkListener));
    }

    @Test
    public void tracksPrameterizedWorkScheduling() throws Exception {
        Work work = (Work)Mockito.mock(Work.class);
        long startTimeout = 0L;
        ExecutionContext execContext = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        WorkListener workListener = (WorkListener)Mockito.mock(WorkListener.class);
        final ArgumentCaptor argument = ArgumentCaptor.forClass(Work.class);
        ((WorkManager)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((Work)argument.getValue()).run();
                return null;
            }
        }).when((Object)this.delegateWorkManager)).scheduleWork((Work)argument.capture(), Matchers.eq((long)startTimeout), (ExecutionContext)Matchers.eq((Object)execContext), (WorkListener)Matchers.any());
        this.trackingWorkManager.scheduleWork(work, startTimeout, execContext, workListener);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.workTracker, this.delegateWorkManager});
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).addWork((Runnable)work);
        ((WorkManager)inOrder.verify((Object)this.delegateWorkManager)).scheduleWork((Work)argument.capture(), Matchers.eq((long)startTimeout), (ExecutionContext)Matchers.eq((Object)execContext), (WorkListener)Matchers.any());
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).removeWork((Runnable)work);
    }

    @Test
    public void untracksParameterizedWorkOnSchedulingWorkException() throws Exception {
        Work work = (Work)Mockito.mock(Work.class);
        long startTimeout = 0L;
        ExecutionContext execContext = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        WorkListener workListener = (WorkListener)Mockito.mock(WorkListener.class);
        ((WorkManager)Mockito.doThrow((Throwable)new WorkException()).when((Object)this.delegateWorkManager)).scheduleWork((Work)Matchers.any(), Matchers.eq((long)startTimeout), (ExecutionContext)Matchers.eq((Object)execContext), (WorkListener)Matchers.any());
        try {
            this.trackingWorkManager.scheduleWork(work, startTimeout, execContext, workListener);
            this.expectedExceptionFail();
        }
        catch (Exception e) {
            // empty catch block
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.workTracker, this.delegateWorkManager});
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).addWork((Runnable)work);
        ((WorkManager)inOrder.verify((Object)this.delegateWorkManager)).scheduleWork((Work)Matchers.any(), Matchers.eq((long)startTimeout), (ExecutionContext)Matchers.eq((Object)execContext), (WorkListener)Matchers.any());
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).removeWork((Runnable)work);
    }

    @Test
    public void untracksParameterizedWorkOnSchedulingRuntimeException() throws Exception {
        Work work = (Work)Mockito.mock(Work.class);
        long startTimeout = 0L;
        ExecutionContext execContext = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        WorkListener workListener = (WorkListener)Mockito.mock(WorkListener.class);
        ((WorkManager)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)this.delegateWorkManager)).scheduleWork((Work)Matchers.any(), Matchers.eq((long)startTimeout), (ExecutionContext)Matchers.eq((Object)execContext), (WorkListener)Matchers.any());
        try {
            this.trackingWorkManager.scheduleWork(work, startTimeout, execContext, workListener);
            this.expectedExceptionFail();
        }
        catch (Exception e) {
            // empty catch block
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.workTracker, this.delegateWorkManager});
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).addWork((Runnable)work);
        ((WorkManager)inOrder.verify((Object)this.delegateWorkManager)).scheduleWork((Work)Matchers.any(), Matchers.eq((long)startTimeout), (ExecutionContext)Matchers.eq((Object)execContext), (WorkListener)Matchers.any());
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).removeWork((Runnable)work);
    }

    @Test
    public void untracksParameterizedWorkOnSchedulingExecutionException() throws Exception {
        Work work = (Work)Mockito.mock(Work.class);
        ((Work)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)work)).run();
        long startTimeout = 0L;
        ExecutionContext execContext = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        WorkListener workListener = (WorkListener)Mockito.mock(WorkListener.class);
        final ArgumentCaptor argument = ArgumentCaptor.forClass(Work.class);
        ((WorkManager)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Thread schedulerThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ((Work)argument.getValue()).run();
                    }
                });
                schedulerThread.start();
                return null;
            }
        }).when((Object)this.delegateWorkManager)).scheduleWork((Work)argument.capture(), Matchers.eq((long)startTimeout), (ExecutionContext)Matchers.eq((Object)execContext), (WorkListener)Matchers.any());
        this.trackingWorkManager.scheduleWork(work, startTimeout, execContext, workListener);
        ((Work)Mockito.verify((Object)work, (VerificationMode)Mockito.timeout((int)5000))).run();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.workTracker, this.delegateWorkManager});
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).addWork((Runnable)work);
        ((WorkManager)inOrder.verify((Object)this.delegateWorkManager)).scheduleWork((Work)argument.capture(), Matchers.eq((long)startTimeout), (ExecutionContext)Matchers.eq((Object)execContext), (WorkListener)Matchers.any());
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).removeWork((Runnable)work);
    }

    @Test
    public void executesWork() throws Exception {
        Work work = (Work)Mockito.mock(Work.class);
        final ArgumentCaptor argument = ArgumentCaptor.forClass(Runnable.class);
        ((WorkManager)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((Runnable)argument.getValue()).run();
                return null;
            }
        }).when((Object)this.delegateWorkManager)).execute((Runnable)argument.capture());
        this.trackingWorkManager.execute((Runnable)work);
        ((Work)Mockito.verify((Object)work)).run();
    }

    @Test
    public void tracksWorkExecution() throws Exception {
        Work work = (Work)Mockito.mock(Work.class);
        final ArgumentCaptor argument = ArgumentCaptor.forClass(Runnable.class);
        ((WorkManager)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((Runnable)argument.getValue()).run();
                return null;
            }
        }).when((Object)this.delegateWorkManager)).execute((Runnable)argument.capture());
        this.trackingWorkManager.execute((Runnable)work);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.workTracker, this.delegateWorkManager});
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).addWork((Runnable)work);
        ((WorkManager)inOrder.verify((Object)this.delegateWorkManager)).execute((Runnable)Matchers.any());
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).removeWork((Runnable)work);
    }

    @Test
    public void untracksWorkOnExecutionException() throws Exception {
        Runnable work = (Runnable)Mockito.mock(Runnable.class);
        ((WorkManager)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)this.delegateWorkManager)).execute((Runnable)Matchers.any());
        try {
            this.trackingWorkManager.execute(work);
            this.expectedExceptionFail();
        }
        catch (Exception e) {
            // empty catch block
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.workTracker, this.delegateWorkManager});
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).addWork(work);
        ((WorkManager)inOrder.verify((Object)this.delegateWorkManager)).execute((Runnable)Matchers.any());
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).removeWork(work);
    }

    @Test
    public void untracksWorkOnExecuteExecutionException() throws Exception {
        Runnable work = (Runnable)Mockito.mock(Runnable.class);
        ((Runnable)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)work)).run();
        final ArgumentCaptor argument = ArgumentCaptor.forClass(Runnable.class);
        ((WorkManager)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Thread schedulerThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ((Runnable)argument.getValue()).run();
                    }
                });
                schedulerThread.start();
                return null;
            }
        }).when((Object)this.delegateWorkManager)).execute((Runnable)argument.capture());
        this.trackingWorkManager.execute(work);
        ((Runnable)Mockito.verify((Object)work, (VerificationMode)Mockito.timeout((int)5000))).run();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.workTracker, this.delegateWorkManager});
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).addWork(work);
        ((WorkManager)inOrder.verify((Object)this.delegateWorkManager)).execute((Runnable)Matchers.any());
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).removeWork(work);
    }

    @Test
    public void waitsForWorkCompletion() throws Exception {
        Work work = (Work)Mockito.mock(Work.class);
        this.trackingWorkManager.scheduleWork(work);
        List<Work> pendingWorks = Collections.singletonList(work);
        Mockito.when((Object)this.workTracker.pendingWorks()).thenReturn(pendingWorks).thenReturn(pendingWorks).thenReturn(Collections.emptyList());
        this.trackingWorkManager.dispose();
        ((WorkTracker)Mockito.verify((Object)this.workTracker, (VerificationMode)Mockito.times((int)3))).pendingWorks();
    }

    @Test
    public void disposesWorkTracker() throws Exception {
        this.trackingWorkManager.dispose();
        ((WorkTracker)Mockito.verify((Object)this.workTracker)).dispose();
    }

    private void expectedExceptionFail() {
        Assert.fail((String)"Should throw an exception");
    }

    private void assertWorkIsTracked(Work work) throws WorkException {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.workTracker, this.delegateWorkManager});
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).addWork((Runnable)work);
        ((WorkManager)inOrder.verify((Object)this.delegateWorkManager)).doWork(work);
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).removeWork((Runnable)work);
    }

    private void assertParameterizedWorkWasTracked(Work work, int startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.workTracker, this.delegateWorkManager});
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).addWork((Runnable)work);
        ((WorkManager)inOrder.verify((Object)this.delegateWorkManager)).doWork(work, (long)startTimeout, execContext, workListener);
        ((WorkTracker)inOrder.verify((Object)this.workTracker)).removeWork((Runnable)work);
    }
}

