/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mule.api.MuleContext;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStoreException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.store.PersistentObjectStorePartition;

@SmallTest
public class PersistentObjectStorePartitionTestCase
extends AbstractMuleTestCase {
    @Rule
    public TemporaryFolder objectStoreFolder = new TemporaryFolder();

    @Test
    public void indicatesUnexistentKeyOnRetrieveError() throws ObjectStoreException {
        MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        PersistentObjectStorePartition partition = new PersistentObjectStorePartition(muleContext, "test", this.objectStoreFolder.getRoot());
        partition.open();
        String nonExistentKey = "nonExistentKey";
        try {
            partition.retrieve((Serializable)((Object)"nonExistentKey"));
            Assert.fail((String)"Supposed to thrown an exception as key is not valid");
        }
        catch (ObjectDoesNotExistException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("nonExistentKey"));
        }
    }
}

