/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ajax;

import org.cometd.Bayeux;
import org.cometd.Client;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.BayeuxService;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connector;
import org.mule.api.transport.PropertyScope;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.ajax.BayeuxAware;
import org.mule.transport.ajax.embedded.AjaxConnector;
import org.mule.transport.ajax.i18n.AjaxMessages;
import org.mule.util.StringUtils;

public class AjaxMessageReceiver
extends AbstractMessageReceiver
implements BayeuxAware {
    private AbstractBayeux bayeux;

    public AjaxMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
        String channel = endpoint.getEndpointURI().getPath();
        if (StringUtils.isEmpty((String)channel) || channel.equals("/")) {
            throw new CreateException(AjaxMessages.createStaticMessage((String)"The subscription path cannot be empty or equal '/'"), (Object)this);
        }
    }

    @Override
    public AbstractBayeux getBayeux() {
        return this.bayeux;
    }

    @Override
    public void setBayeux(AbstractBayeux bayeux) {
        this.bayeux = bayeux;
    }

    protected void doStart() throws MuleException {
        String channel = this.endpoint.getEndpointURI().getPath();
        new ReceiverService(channel, (Bayeux)this.getBayeux(), (ImmutableEndpoint)this.getEndpoint());
    }

    public class ReceiverService
    extends BayeuxService {
        private final ImmutableEndpoint endpoint;

        public ReceiverService(String channel, Bayeux bayeux, ImmutableEndpoint endpoint) {
            super(bayeux, channel);
            this.endpoint = endpoint;
            this.subscribe(channel, "route");
        }

        public Object route(Client client, Object data) throws Exception {
            AjaxConnector ajaxConnector;
            MuleEvent event;
            MuleMessage message;
            MuleMessage messageToRoute = AjaxMessageReceiver.this.createMuleMessage(data, this.endpoint.getEncoding());
            messageToRoute.setInvocationProperty("cometd.client", (Object)client);
            Object replyTo = messageToRoute.getReplyTo();
            if (replyTo != null) {
                messageToRoute.setProperty("MULE_FORCE_SYNC", (Object)Boolean.TRUE, PropertyScope.INBOUND);
            }
            MuleMessage muleMessage = message = (event = AjaxMessageReceiver.this.routeMessage(messageToRoute)) == null ? null : event.getMessage();
            if (AjaxMessageReceiver.this.getConnector() instanceof AjaxConnector && !(ajaxConnector = (AjaxConnector)AjaxMessageReceiver.this.getConnector()).isDisableReplyTo() && message != null && message.getExceptionPayload() == null && replyTo != null) {
                ajaxConnector.getReplyToHandler(this.endpoint).processReplyTo(RequestContext.getEvent(), message, replyTo);
            }
            return null;
        }
    }
}

