/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.httpclient.ChunkedInputStream;
import org.apache.commons.httpclient.ContentLengthInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HeaderGroup;
import org.apache.commons.httpclient.NameValuePair;
import org.mule.transport.http.RequestLine;
import org.mule.util.IOUtils;

public class HttpRequest {
    private RequestLine requestLine = null;
    private HeaderGroup headers = new HeaderGroup();
    private InputStream entity = null;
    private String defaultEncoding;

    public HttpRequest(RequestLine requestLine, Header[] headers, String defaultEncoding) throws IOException {
        this(requestLine, headers, null, defaultEncoding);
    }

    public HttpRequest(RequestLine requestLine, Header[] headers, InputStream content, String defaultEncoding) throws IOException {
        if (requestLine == null) {
            throw new IllegalArgumentException("Request line may not be null");
        }
        this.requestLine = requestLine;
        this.defaultEncoding = defaultEncoding;
        if (headers != null) {
            this.headers.setHeaders(headers);
        }
        if (content != null && this.shouldProcessContent()) {
            long len;
            Header contentLength = this.headers.getFirstHeader("Content-Length");
            Header transferEncoding = this.headers.getFirstHeader("Transfer-Encoding");
            InputStream in = content;
            if (transferEncoding != null) {
                if (transferEncoding.getValue().indexOf("chunked") != -1) {
                    in = new ChunkedInputStream(in);
                }
            } else if (contentLength != null && (len = this.getContentLength()) >= 0L) {
                in = new ContentLengthInputStream(in, len);
            }
            this.entity = in;
        }
    }

    private boolean shouldProcessContent() {
        String methodName = this.requestLine.getMethod();
        return "POST".equalsIgnoreCase(methodName) || "PUT".equalsIgnoreCase(methodName) || "PATCH".equalsIgnoreCase(methodName);
    }

    public RequestLine getRequestLine() {
        return this.requestLine;
    }

    public void setRequestLine(RequestLine requestline) {
        if (requestline == null) {
            throw new IllegalArgumentException("Request line may not be null");
        }
        this.requestLine = requestline;
    }

    public boolean containsHeader(String name) {
        return this.headers.containsHeader(name);
    }

    public Header[] getHeaders() {
        return this.headers.getAllHeaders();
    }

    public Header getFirstHeader(String s) {
        return this.headers.getFirstHeader(s);
    }

    public void removeHeaders(String s) {
        if (s == null) {
            return;
        }
        Header[] headersToRemove = this.headers.getHeaders(s);
        for (int i = 0; i < headersToRemove.length; ++i) {
            this.headers.removeHeader(headersToRemove[i]);
        }
    }

    public void addHeader(Header header) {
        if (header == null) {
            return;
        }
        this.headers.addHeader(header);
    }

    public void setHeader(Header header) {
        if (header == null) {
            return;
        }
        this.removeHeaders(header.getName());
        this.addHeader(header);
    }

    public Iterator<?> getHeaderIterator() {
        return this.headers.getIterator();
    }

    public String getContentType() {
        Header contenttype = this.headers.getFirstHeader("Content-Type");
        if (contenttype != null) {
            return contenttype.getValue();
        }
        return "text/plain";
    }

    public String getCharset() {
        NameValuePair param;
        HeaderElement[] values;
        String charset = null;
        Header contenttype = this.headers.getFirstHeader("Content-Type");
        if (contenttype != null && (values = contenttype.getElements()).length == 1 && (param = values[0].getParameterByName("charset")) != null) {
            charset = param.getValue();
        }
        if (charset != null) {
            return charset;
        }
        return this.defaultEncoding;
    }

    public long getContentLength() {
        Header contentLength = this.headers.getFirstHeader("Content-Length");
        if (contentLength != null) {
            try {
                return Long.parseLong(contentLength.getValue());
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }
        return -1L;
    }

    public InputStream getBody() {
        return this.entity;
    }

    public byte[] getBodyBytes() throws IOException {
        InputStream in = this.getBody();
        if (in != null) {
            return IOUtils.toByteArray((InputStream)in);
        }
        return null;
    }

    public String getBodyString() throws IOException {
        byte[] raw = this.getBodyBytes();
        if (raw != null) {
            return new String(raw, this.getCharset());
        }
        return null;
    }

    public String getUrlWithoutParams() {
        return this.requestLine.getUrlWithoutParams();
    }
}

