/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Launcher
extends Thread {
    Task task;
    String[] command;
    String endMsg;
    File dir;
    Map<String, String> environmentVariables = new HashMap<String, String>();

    public Launcher(Task task, String[] command, String endMsg, String dir) {
        this.task = task;
        this.command = command;
        this.endMsg = endMsg;
        this.dir = dir != null ? new File(dir) : null;
    }

    public void run() {
        String logCommand = "";
        for (String commandPart : this.command) {
            logCommand = logCommand + commandPart + " ";
        }
        try {
            this.task.log("starting '" + logCommand + "'...");
            ProcessBuilder processBuilder = new ProcessBuilder(this.command).redirectErrorStream(true).directory(this.dir);
            if (!this.environmentVariables.isEmpty()) {
                processBuilder.environment().putAll(this.environmentVariables);
            }
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = "";
            while (line.indexOf(this.endMsg) == -1) {
                line = reader.readLine();
                this.task.log(line);
            }
            this.task.log("'" + this.command[0] + "' started.");
        }
        catch (IOException e) {
            throw new BuildException("couldn't start '" + logCommand + "'", (Throwable)e);
        }
    }

    public void setEnvironmentVariable(String variableName, String value) {
        this.environmentVariables.put(variableName, value);
    }
}

