/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.binding;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.binding.WireDescriptorBinding;
import org.jbpm.pvm.internal.wire.descriptor.PropertiesDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.StringDescriptor;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

public class PropertiesBinding
extends WireDescriptorBinding {
    public PropertiesBinding() {
        super("properties");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        return PropertiesBinding.parseDescriptor(element, parse, parser);
    }

    public static PropertiesDescriptor parseDescriptor(Element element, Parse parse, Parser parser) {
        Boolean isXml;
        PropertiesDescriptor descriptor = new PropertiesDescriptor();
        if (element.hasAttribute("file")) {
            descriptor.setFile(element.getAttribute("file"));
        }
        if (element.hasAttribute("resource")) {
            descriptor.setResource(element.getAttribute("resource"));
        }
        if (element.hasAttribute("url")) {
            descriptor.setUrl(element.getAttribute("url"));
        }
        if ((isXml = XmlUtil.attributeBoolean(element, "is-xml", parse)) != null) {
            descriptor.setXml(isXml);
        }
        ArrayList<Descriptor> keyDescriptors = new ArrayList<Descriptor>();
        ArrayList<Descriptor> valueDescriptors = new ArrayList<Descriptor>();
        List<Element> elements = XmlUtil.elements(element);
        for (Element propertyElement : elements) {
            if ("property".equals(propertyElement.getLocalName())) {
                String name = XmlUtil.attribute(propertyElement, "name");
                String value = XmlUtil.attribute(propertyElement, "value");
                if (name != null && value != null) {
                    keyDescriptors.add(new StringDescriptor(name));
                    valueDescriptors.add(new StringDescriptor(value));
                    continue;
                }
                parse.addProblem("property must have name and value attributes: " + XmlUtil.toString(propertyElement), element);
                continue;
            }
            parse.addProblem("properties can only contain property elements: " + XmlUtil.toString(propertyElement), element);
        }
        descriptor.setKeyDescriptors(keyDescriptors);
        descriptor.setValueDescriptors(valueDescriptors);
        return descriptor;
    }
}

