/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.operation;

import java.util.HashSet;
import java.util.List;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.util.FilterListener;
import org.jbpm.pvm.internal.util.Listener;
import org.jbpm.pvm.internal.util.Observable;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.WireContext;
import org.jbpm.pvm.internal.wire.WireDefinition;
import org.jbpm.pvm.internal.wire.WireException;
import org.jbpm.pvm.internal.wire.descriptor.ArgDescriptor;
import org.jbpm.pvm.internal.wire.operation.MethodInvokerListener;
import org.jbpm.pvm.internal.wire.operation.Operation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscribeOperation
implements Operation {
    private static final long serialVersionUID = 1L;
    private static Log log = Log.getLog((String)SubscribeOperation.class.getName());
    String contextName = null;
    List<String> eventNames = null;
    boolean wireEvents = false;
    List<String> objectNames = null;
    String methodName = null;
    List<ArgDescriptor> argDescriptors = null;

    @Override
    public void apply(Object target, WireContext targetWireContext) {
        WireContext wireContext;
        Listener listener;
        block21: {
            listener = null;
            if (this.methodName != null) {
                listener = new MethodInvokerListener(this.methodName, this.argDescriptors, targetWireContext, target);
            } else {
                try {
                    listener = (Listener)target;
                }
                catch (ClassCastException e) {
                    throw new WireException("couldn't subscribe object " + target + " because it is not a Listener");
                }
            }
            if (this.eventNames != null && !this.eventNames.isEmpty()) {
                listener = new FilterListener(listener, this.eventNames);
            }
            wireContext = null;
            if (this.contextName != null) {
                EnvironmentImpl environment = EnvironmentImpl.getCurrent();
                if (environment != null) {
                    try {
                        wireContext = (WireContext)environment.getContext(this.contextName);
                        if (wireContext == null) {
                            throw new WireException("couldn't subscribe because context " + this.contextName + " doesn't exist");
                        }
                        break block21;
                    }
                    catch (ClassCastException e) {
                        throw new WireException("couldn't subscribe because context " + this.contextName + " is not a WireContext", e);
                    }
                }
                throw new WireException("couldn't get context " + this.contextName + " for subscribe because no environment available in context " + targetWireContext);
            }
            wireContext = targetWireContext;
        }
        if (this.wireEvents) {
            WireDefinition wireDefinition = wireContext.getWireDefinition();
            if (this.objectNames != null) {
                for (String objectName : this.objectNames) {
                    Descriptor descriptor = wireDefinition.getDescriptor(objectName);
                    this.subscribe(listener, descriptor);
                }
            } else {
                HashSet<Descriptor> descriptors = new HashSet<Descriptor>(wireDefinition.getDescriptors().values());
                for (Descriptor descriptor : descriptors) {
                    this.subscribe(listener, descriptor);
                }
            }
        } else if (this.objectNames != null && !this.objectNames.isEmpty()) {
            for (String objectName : this.objectNames) {
                Object object = wireContext.get(objectName);
                if (object == null) {
                    throw new WireException("couldn't subscribe to object in context " + wireContext.getName() + ": object " + objectName + " unavailable");
                }
                if (!(object instanceof Observable)) {
                    throw new WireException("couldn't subscribe to object in context " + wireContext.getName() + ": object " + objectName + " (" + object.getClass().getName() + ") isn't " + Observable.class.getName());
                }
                this.subscribe(listener, (Observable)object);
            }
        } else {
            this.subscribe(listener, wireContext);
        }
    }

    void subscribe(Listener listener, Observable observable) {
        log.trace("adding " + listener + " as listener to " + observable);
        observable.addListener(listener);
    }

    public List<ArgDescriptor> getArgDescriptors() {
        return this.argDescriptors;
    }

    public void setArgDescriptors(List<ArgDescriptor> argDescriptors) {
        this.argDescriptors = argDescriptors;
    }

    public List<String> getEventNames() {
        return this.eventNames;
    }

    public void setEventNames(List<String> eventNames) {
        this.eventNames = eventNames;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public List<String> getObjectNames() {
        return this.objectNames;
    }

    public void setObjectNames(List<String> objectNames) {
        this.objectNames = objectNames;
    }

    public boolean isWireEvents() {
        return this.wireEvents;
    }

    public void setWireEvents(boolean wireEvents) {
        this.wireEvents = wireEvents;
    }
}

